/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.connector.plugins.web.fetcher.http.client;

import com.google.inject.Inject;
import com.lucidworks.connector.plugins.web.config.WebConfig;
import com.lucidworks.connector.plugins.web.fetcher.JsEvaluator;
import com.lucidworks.connector.plugins.web.fetcher.http.RobotsTxt;
import com.lucidworks.connector.plugins.web.fetcher.http.client.LinkValidator;
import com.lucidworks.connector.plugins.web.fetcher.http.client.RequestExecutor;
import com.lucidworks.connector.plugins.web.fetcher.http.client.WebClientResponse;
import com.lucidworks.connector.plugins.web.fetcher.http.login.CredentialsWrapper;
import com.lucidworks.connector.plugins.web.fetcher.http.tokenauth.AccessTokenRequester;
import com.lucidworks.connector.plugins.web.util.DateUtil;
import com.lucidworks.connector.plugins.web.util.HttpClientUtil;
import com.lucidworks.fusion.connector.plugin.api.fetcher.type.content.FetchInput;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.jetbrains.annotations.NotNull;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Entities;
import org.jsoup.parser.Parser;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebClient {
    private static final Logger logger = LoggerFactory.getLogger(WebClient.class);
    private static final ThreadLocal<SimpleDateFormat> HTTP_DATE_FORMATTER = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return DateUtil.getRFC2822DateFormatter();
        }
    };
    private static final ThreadLocal<Matcher> META_EQUIV_REFRESH_REGEX = new ThreadLocal<Matcher>(){

        @Override
        protected Matcher initialValue() {
            return Pattern.compile("(?si)\\d+;\\s*url=(.+)|\\d+", 2).matcher("");
        }
    };
    public static final Set<String> XML_MIMETYPES = new HashSet<String>(){
        {
            this.add("text/xml");
            this.add("application/xml");
            this.add("application/xhtml+xml");
            this.add("application/atom+xml");
            this.add("application/rss+xml");
            this.add("application/rdf+xml");
        }
    };
    private static final Set<String> PARSEABLE_MIME_TYPES = new HashSet<String>(){
        {
            this.add("text/html");
            this.addAll(XML_MIMETYPES);
        }
    };
    private static final String META_EQUIV_REFRESH_SELECTOR = "head meta[http-equiv=refresh]";
    public static final String LENGTH_L = "length_l";
    private final Boolean jsEnabledAuth;
    private final Boolean maintainCookies;
    private final WebConfig config;
    private final CloseableHttpClient httpClient;
    private final CredentialsWrapper credentialsWrapper;
    private final BasicCookieStore sharedCookieStore;
    private final RobotsTxt robotsTXT;
    private final Integer timeout;
    private final LinkValidator linkValidator;
    private final Boolean followCanonicalTags;
    private final Integer canonicalTagsRedirectLimit;
    private final Boolean diagnosticMode;
    private final Boolean respectMetaEquivRedirects;
    private final String defaultCharSet;
    private final RequestExecutor exec;
    private final AccessTokenRequester tokenRequester;
    private final JsEvaluator jsEvaluator;

    @Inject
    public WebClient(WebConfig config, CloseableHttpClient httpClient, CredentialsWrapper credentialsWrapper, @Nullable AccessTokenRequester tokenRequester, RobotsTxt robotsTXT, LinkValidator linkValidator, RequestExecutor executor, JsEvaluator jsEvaluator, BasicCookieStore sharedCookieStore) {
        this.config = config;
        this.httpClient = httpClient;
        this.credentialsWrapper = credentialsWrapper;
        this.tokenRequester = tokenRequester;
        this.robotsTXT = robotsTXT;
        this.jsEnabledAuth = config.properties().javascriptEvaluationConfig().jsEnabledAuth();
        this.maintainCookies = config.properties().crawlAuthenticationConfig().maintainCookies();
        this.sharedCookieStore = sharedCookieStore;
        this.timeout = config.properties().crawlPerformanceConfig().timeoutMS();
        this.linkValidator = linkValidator;
        this.followCanonicalTags = config.properties().dedupeConfig().followCanonicalTags();
        this.canonicalTagsRedirectLimit = config.properties().dedupeConfig().canonicalTagsRedirectLimit();
        this.diagnosticMode = config.diagnosticLogging();
        this.respectMetaEquivRedirects = config.properties().linkDiscoveryConfig().respectMetaEquivRedirects();
        this.defaultCharSet = config.properties().documentParsingConfig().defaultCharSet();
        this.exec = executor;
        this.jsEvaluator = jsEvaluator;
    }

    public WebClientResponse fetch(FetchInput input) {
        String signature = input.getMetadata().getOrDefault("signature", "");
        Long lastModified = input.getMetadata().getOrDefault("lastModified", 0L);
        return this.fetchWithRedirects(input.getId(), lastModified, signature, 0);
    }

    public WebClientResponse fetchWithRedirects(String origID, int redirectCounter) {
        return this.fetchWithRedirects(origID, 0L, null, redirectCounter);
    }

    /*
     * Exception decompiling
     */
    public WebClientResponse fetchWithRedirects(String origID, long lastModified, String signature, int redirectCounter) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @NotNull
    private Document getDocument(String fetchedID, String mimeType, String parseCharSet, byte[] rawContent) throws UnsupportedEncodingException {
        Parser parser = XML_MIMETYPES.contains(mimeType) ? Parser.xmlParser() : Parser.htmlParser();
        Document document = Jsoup.parse((String)new String(rawContent, parseCharSet), (String)fetchedID, (Parser)parser);
        document.outputSettings().charset(parseCharSet);
        document.setBaseUri(fetchedID);
        document.outputSettings().escapeMode(Entities.EscapeMode.extended);
        return document;
    }

    private Boolean getObeyRobotsDelay() {
        return this.config.properties().crawlPerformanceConfig().obeyRobotsDelay();
    }

    private String getMetaEquivRedirect(Document doc) {
        String redirect = null;
        Elements elements = doc.select(META_EQUIV_REFRESH_SELECTOR);
        if (!elements.isEmpty()) {
            Element e = elements.first();
            Matcher m = META_EQUIV_REFRESH_REGEX.get().reset(e.attr("content"));
            if (m.find()) {
                redirect = e.attr("__url__", m.group(1)).absUrl("__url__");
                if (this.diagnosticMode.booleanValue()) {
                    logger.info("Meta http-equiv redirect: [ {} -> {} ]", (Object)doc.baseUri(), (Object)redirect);
                }
            }
        }
        return redirect;
    }

    private String getParseCharSet(String charSet) {
        return null != charSet && Charset.isSupported(charSet) ? charSet : this.defaultCharSet;
    }

    private HttpResponse runRequest(HttpGet req, HttpContext context) throws TimeoutException, InterruptedException, ExecutionException {
        HttpResponse resp;
        int status;
        if (this.tokenRequester != null) {
            req.addHeader((Header)this.getAuthorizationHeader(this.tokenRequester.getAccessToken()));
        }
        if ((status = (resp = HttpClientUtil.request((HttpClient)this.httpClient, (HttpUriRequest)req, context, this.exec.get(), this.timeout)).getStatusLine().getStatusCode()) == 401 && this.tokenRequester != null) {
            logger.warn("Request unauthorized - trying with new access token");
            req.setHeader((Header)this.getAuthorizationHeader(this.tokenRequester.getNewAccessToken()));
            resp = HttpClientUtil.request((HttpClient)this.httpClient, (HttpUriRequest)req, context, this.exec.get(), this.timeout);
        }
        return resp;
    }

    @NotNull
    private BasicHeader getAuthorizationHeader(String accessToken) {
        return new BasicHeader("Authorization", "Bearer " + accessToken);
    }

    private HttpContext setupRequest(String origID, long lastModified, String signature, HttpGet req) throws URISyntaxException, IOException {
        BasicHttpContext context = new BasicHttpContext();
        if (this.credentialsWrapper.hasFormLogins()) {
            this.credentialsWrapper.getFormLogins().login((HttpClient)this.httpClient);
        }
        if (this.credentialsWrapper.hasSmartFormLogins() && !this.jsEnabledAuth.booleanValue()) {
            this.credentialsWrapper.getSmartFormLogins().login(this.httpClient, this.sharedCookieStore);
        }
        if (!(this.maintainCookies.booleanValue() || this.credentialsWrapper.hasFormLogins() || this.credentialsWrapper.hasHttpLogins() || this.credentialsWrapper.hasSmartFormLogins())) {
            this.sharedCookieStore.clear();
        }
        req.setURI(URIUtils.resolve((URI)new URI(origID), (String)""));
        if (lastModified > 0L) {
            req.addHeader("If-Modified-Since", HTTP_DATE_FORMATTER.get().format(new Date(lastModified)));
        }
        if (null != signature) {
            req.addHeader("If-None-Match", signature);
        }
        String addedHeaders = this.config.properties().linkDiscoveryConfig().addedHeaders();
        HttpClientUtil.putAddedHeadersIntoHttpGet(req, addedHeaders);
        return context;
    }

    public void close() throws IOException {
        this.httpClient.close();
        this.jsEvaluator.close();
        this.exec.shutdown();
    }
}

