/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.connector.plugins.web.fetcher.http.client;

import com.google.inject.Inject;
import com.lucidworks.connector.plugins.web.WebConnectorException;
import com.lucidworks.connector.plugins.web.config.WebConfig;
import com.lucidworks.connector.plugins.web.util.LRUSet;
import com.lucidworks.connector.plugins.web.util.Utils;
import java.lang.invoke.CallSite;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkChecker {
    private static final Logger LOG = LoggerFactory.getLogger(LinkChecker.class);
    private final int linkCacheSize;
    private final boolean diagnosticMode;
    private final Set<String> excludeRegexes;
    private final Set<String> includeRegexes;
    private final Set<String> excludeExtRegexes;
    private final Set<String> includeExtRegexes;
    private final Set<String> treeRegexes;
    private final LRUSet<String> illegalLinksCache;
    private final LRUSet<String> legalLinksCache;
    private final WebConfig config;
    private volatile boolean compiled;
    private ThreadLocal<Set<Matcher>> excludeMatchers;
    private ThreadLocal<Set<Matcher>> includeMatchers;
    private ThreadLocal<Set<Matcher>> excludeExtMatchers;
    private ThreadLocal<Set<Matcher>> includeExtMatchers;
    private ThreadLocal<Set<Matcher>> treeMatchers;
    boolean checkLinkLegality;

    @Inject
    public LinkChecker(WebConfig config) {
        this.linkCacheSize = 10000;
        this.diagnosticMode = config.diagnosticLogging();
        this.excludeExtRegexes = new HashSet<String>();
        this.includeExtRegexes = new HashSet<String>();
        this.excludeRegexes = new HashSet<String>();
        this.includeRegexes = new HashSet<String>();
        this.treeRegexes = new HashSet<String>();
        this.illegalLinksCache = new LRUSet(this.linkCacheSize);
        this.legalLinksCache = new LRUSet(this.linkCacheSize);
        this.config = config;
        this.setupLinkLegality();
    }

    private void setupLinkLegality() {
        boolean restrictToTree = this.config.properties().linkDiscoveryConfig().restrictToTree();
        List<String> excludeExt = this.config.properties().limitDocumentsConfig().excludeExtensions();
        List<String> includeExt = this.config.properties().limitDocumentsConfig().includeExtensions();
        List<String> excludeRegexes = this.config.properties().limitDocumentsConfig().excludeRegexes();
        List<String> includeRegexes = this.config.properties().limitDocumentsConfig().includeRegexes();
        boolean bl = this.checkLinkLegality = !excludeExt.isEmpty() || !includeExt.isEmpty() || !excludeRegexes.isEmpty() || !includeRegexes.isEmpty() || restrictToTree;
        if (this.checkLinkLegality) {
            if (!excludeExt.isEmpty()) {
                this.addExcludeExtRegexes(this.makeExtRegexes(excludeExt.toArray(new String[0]), false));
            }
            if (!includeExt.isEmpty()) {
                this.addIncludeExtRegexes(this.makeExtRegexes(includeExt.toArray(new String[0]), true));
            }
            if (null != excludeRegexes) {
                this.addExcludeRegexes(excludeRegexes.toArray(new String[0]));
            }
            if (null != includeRegexes) {
                this.addIncludeRegexes(includeRegexes.toArray(new String[0]));
            }
            if (restrictToTree) {
                try {
                    this.addTreeRegexes(LinkChecker.makeTreeRegexes(this.config.properties().startLinks().toArray(new String[0]), this.config.properties().linkDiscoveryConfig().restrictToTreeIgnoredHostPrefixes().toArray(new String[0]), this.config.properties().linkDiscoveryConfig().restrictToTreeAllowSubdomains(), this.config.properties().linkDiscoveryConfig().restrictToTreeUseHostAndPath()));
                }
                catch (URISyntaxException e) {
                    throw new WebConnectorException("Failed to initialize the LinkChecker", e);
                }
            }
            this.compile();
            LOG.info("LinkChecker configuration: {}{} ", (Object)Utils.NEWLINE, (Object)Utils.tab(this.toString(), 1));
        }
    }

    public synchronized void addExcludeRegexes(String ... regexStrs) {
        this.checkCompiled(false);
        Collections.addAll(this.excludeRegexes, regexStrs);
    }

    public synchronized void addIncludeRegexes(String ... regexStrs) {
        this.checkCompiled(false);
        Collections.addAll(this.includeRegexes, regexStrs);
    }

    public synchronized void addExcludeExtRegexes(String ... regexStrs) {
        this.checkCompiled(false);
        Collections.addAll(this.excludeExtRegexes, regexStrs);
    }

    public synchronized void addIncludeExtRegexes(String ... regexStrs) {
        this.checkCompiled(false);
        Collections.addAll(this.includeExtRegexes, regexStrs);
    }

    public synchronized void addTreeRegexes(String ... regexStrs) {
        this.checkCompiled(false);
        Collections.addAll(this.treeRegexes, regexStrs);
    }

    public Set<String> getExcludeRegexes() {
        return this.excludeRegexes;
    }

    public Set<String> getIncludeRegexes() {
        return this.includeRegexes;
    }

    public Set<String> getExcludeExtRegexes() {
        return this.excludeExtRegexes;
    }

    public Set<String> getIncludeExtRegexes() {
        return this.includeExtRegexes;
    }

    public Set<String> getTreeRegexes() {
        return this.treeRegexes;
    }

    public synchronized void compile() {
        this.checkCompiled(false);
        this.excludeMatchers = Utils.makeThreadLocalMatchers(this.excludeRegexes);
        this.includeMatchers = Utils.makeThreadLocalMatchers(this.includeRegexes);
        this.excludeExtMatchers = Utils.makeThreadLocalMatchers(this.excludeExtRegexes, 2);
        this.includeExtMatchers = Utils.makeThreadLocalMatchers(this.includeExtRegexes, 2);
        this.treeMatchers = Utils.makeThreadLocalMatchers(this.treeRegexes, 2);
        this.compiled = true;
    }

    public boolean isLegalLink(String link) {
        if (!this.checkLinkLegality) {
            return true;
        }
        this.checkCompiled(true);
        if (null != this.illegalLinksCache && this.illegalLinksCache.contains(link)) {
            return false;
        }
        if (null != this.legalLinksCache && this.legalLinksCache.contains(link)) {
            return true;
        }
        for (Matcher excludeExtMatcher : this.excludeExtMatchers.get()) {
            if (!excludeExtMatcher.reset(link).matches()) continue;
            if (null != this.illegalLinksCache) {
                this.illegalLinksCache.add(link);
            }
            if (this.diagnosticMode) {
                LOG.info("Link matches exclude-extension pattern: '{}'", (Object)link);
            }
            return false;
        }
        if (!LinkChecker.checkLinkInclusion(LinkChecker.getEndOfLink(link), this.includeExtMatchers.get())) {
            if (null != this.illegalLinksCache) {
                this.illegalLinksCache.add(link);
            }
            if (this.diagnosticMode) {
                LOG.info("Link does not match any include-extension pattern: '{}'", (Object)link);
            }
            return false;
        }
        for (Matcher excludeMatcher : this.excludeMatchers.get()) {
            if (!excludeMatcher.reset(link).matches()) continue;
            if (null != this.illegalLinksCache) {
                this.illegalLinksCache.add(link);
            }
            if (this.diagnosticMode) {
                LOG.info("Link matches exclude pattern: '{}'", (Object)link);
            }
            return false;
        }
        if (!LinkChecker.checkLinkInclusion(link, this.includeMatchers.get())) {
            if (null != this.illegalLinksCache) {
                this.illegalLinksCache.add(link);
            }
            if (this.diagnosticMode) {
                LOG.info("Link does not match any include pattern: '{}'", (Object)link);
            }
            return false;
        }
        if (!LinkChecker.checkLinkInclusion(link, this.treeMatchers.get())) {
            if (null != this.illegalLinksCache) {
                this.illegalLinksCache.add(link);
            }
            if (this.diagnosticMode) {
                LOG.info("Link is outside of the tree: '{}'", (Object)link);
            }
            return false;
        }
        if (null != this.legalLinksCache) {
            this.legalLinksCache.add(link);
        }
        return true;
    }

    public void clearCaches() {
        if (null != this.legalLinksCache) {
            this.legalLinksCache.clear();
        }
        if (null != this.illegalLinksCache) {
            this.illegalLinksCache.clear();
        }
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("linkCacheSize: ").append(this.linkCacheSize).append(Utils.NEWLINE);
        str.append("excludeExtRegexes:").append(Utils.NEWLINE);
        for (String excludeExtRegex : this.excludeExtRegexes) {
            str.append("\t").append("\"").append(excludeExtRegex).append("\"").append(Utils.NEWLINE);
        }
        str.append("includeExtRegexes:").append(Utils.NEWLINE);
        for (String includeExtRegex : this.includeExtRegexes) {
            str.append("\t").append("\"").append(includeExtRegex).append("\"").append(Utils.NEWLINE);
        }
        str.append("excludeRegexes:").append(Utils.NEWLINE);
        for (String excludeRegex : this.excludeRegexes) {
            str.append("\t").append("\"").append(excludeRegex).append("\"").append(Utils.NEWLINE);
        }
        str.append("includeRegexes:").append(Utils.NEWLINE);
        for (String includeRegex : this.includeRegexes) {
            str.append("\t").append("\"").append(includeRegex).append("\"").append(Utils.NEWLINE);
        }
        str.append("treeRegexes:").append(Utils.NEWLINE);
        for (String treeRegex : this.treeRegexes) {
            str.append("\t").append("\"").append(treeRegex).append("\"").append(Utils.NEWLINE);
        }
        return str.toString();
    }

    public String[] makeExtRegexes(String[] extensions, boolean inclusive) {
        String[] extRegexes = new String[extensions.length];
        for (int i = 0; i < extRegexes.length; ++i) {
            String ext = extensions[i];
            extRegexes[i] = inclusive ? ".*" + Pattern.quote((String)(ext.startsWith(".") ? ext : "." + ext)) + "$|.*\\.+[^\\.]{" + Math.max(6, ext.length()) + "}[^\\.]*$|[^\\.]*$" : ".*" + Pattern.quote((String)(ext.startsWith(".") ? ext : "." + ext)) + "$";
        }
        return extRegexes;
    }

    private void checkCompiled(boolean shouldBeCompiled) {
        if (this.compiled != shouldBeCompiled) {
            throw new IllegalStateException((String)(shouldBeCompiled ? "Not compiled yet, call compile()" : "Already compiled, make a new " + this.getClass().getSimpleName()));
        }
    }

    public static String[] makeTreeRegexes(String[] startLinks, String[] ignoredHostPrefixes, boolean allowSubdomains, boolean useHostAndPath) throws URISyntaxException {
        HashSet<CallSite> treeRegexes = new HashSet<CallSite>();
        for (String startLink : startLinks) {
            URI uri = new URI(Utils.encodeURL(startLink));
            String host = LinkChecker.makeTreeRegexHost(uri.getHost(), ignoredHostPrefixes, allowSubdomains);
            int port = uri.getPort();
            String path = null == uri.getPath() ? "" : Pattern.quote(uri.getPath());
            String scheme = uri.getScheme();
            treeRegexes.add((CallSite)((Object)((String)(scheme == null ? "" : scheme + "://") + (String)(null == host ? path : host + (String)(port > 0 ? ":" + port : "(?::[0-9]{1,5})?") + (useHostAndPath ? path : "/") + ".*"))));
        }
        return treeRegexes.toArray(new String[treeRegexes.size()]);
    }

    private static String makeTreeRegexHost(String host, String[] ignoredHostPrefixes, boolean allowSubdomains) {
        if (null != host) {
            if (null == ignoredHostPrefixes || 0 == ignoredHostPrefixes.length) {
                host = Pattern.quote((String)host);
            } else {
                boolean didReplace = false;
                StringBuilder ihpQuoted = new StringBuilder();
                for (int i = 0; i < ignoredHostPrefixes.length; ++i) {
                    String ignoredHostPrefix = ignoredHostPrefixes[i];
                    if (!didReplace && ((String)host).startsWith(ignoredHostPrefix)) {
                        host = ((String)host).replaceFirst(Pattern.quote(ignoredHostPrefix), "");
                        didReplace = true;
                    }
                    ihpQuoted.append(Pattern.quote(ignoredHostPrefix));
                    if (i >= ignoredHostPrefixes.length - 1) continue;
                    ihpQuoted.append("|");
                }
                host = "(?:" + ihpQuoted.toString() + ")?" + Pattern.quote((String)host);
            }
            if (allowSubdomains) {
                host = "(?:[a-zA-Z0-9\\-]+\\.)*" + (String)host;
            }
        }
        return host;
    }

    private static String getEndOfLink(String link) {
        int start = 0;
        char[] linkC = link.toCharArray();
        for (int i = linkC.length - 1; i >= 0; --i) {
            if (linkC[i] != '/' && linkC[i] != '\\') continue;
            start = i;
            break;
        }
        return link.substring(start);
    }

    private static boolean checkLinkInclusion(String link, Set<Matcher> inclusiveMatchers) {
        if (!inclusiveMatchers.isEmpty()) {
            for (Matcher inclusiveMatcher : inclusiveMatchers) {
                if (!inclusiveMatcher.reset(link).matches()) continue;
                return true;
            }
            return false;
        }
        return true;
    }
}

