/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.connector.plugins.web.fetcher.http;

import com.lucidworks.connector.plugins.web.util.Utils;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;

public class HttpLinkNormalizer {
    private final boolean appendTrailingSlash;
    private final boolean discardLinkURLQueries;
    private final boolean discardLinkURLAnchors;

    public HttpLinkNormalizer() {
        this(false, false, true);
    }

    public HttpLinkNormalizer(boolean appendTrailingSlash, boolean discardLinkURLQueries, boolean discardLinkURLAnchors) {
        this.appendTrailingSlash = appendTrailingSlash;
        this.discardLinkURLQueries = discardLinkURLQueries;
        this.discardLinkURLAnchors = discardLinkURLAnchors;
    }

    public boolean isDiscardLinkURLQueries() {
        return this.discardLinkURLQueries;
    }

    public boolean isDiscardLinkURLAnchors() {
        return this.discardLinkURLAnchors;
    }

    public String normalize(String origURL, String charSet) throws MalformedURLException, UnsupportedEncodingException {
        String sortQuery;
        int anchorIndex = ((String)origURL).indexOf(35);
        if (anchorIndex == 0 || !((String)origURL).startsWith("http") && !((String)origURL).startsWith("https")) {
            return null;
        }
        if (this.appendTrailingSlash && !((String)origURL).endsWith("/")) {
            int dotIndex = ((String)origURL).lastIndexOf(46);
            int slashIndex = ((String)origURL).lastIndexOf(47);
            int varIndex = Math.max(((String)origURL).lastIndexOf(63), ((String)origURL).lastIndexOf(38));
            if (dotIndex == -1 && varIndex == -1) {
                origURL = (String)origURL + "/";
            } else if (slashIndex == -1 && varIndex == -1) {
                origURL = (String)origURL + "/";
            } else if (dotIndex < slashIndex && varIndex < slashIndex) {
                origURL = (String)origURL + "/";
            }
        }
        URL url = new URL((String)origURL);
        boolean needsPort = false;
        if (url.getProtocol().equalsIgnoreCase("http")) {
            if (url.getPort() != -1 && url.getPort() != 80) {
                needsPort = true;
            }
        } else if (url.getProtocol().equalsIgnoreCase("https")) {
            if (url.getPort() != -1 && url.getPort() != 443) {
                needsPort = true;
            }
        } else if (url.getPort() != -1) {
            needsPort = true;
        }
        Object query = null == url.getQuery() ? "" : ((sortQuery = HttpLinkNormalizer.sortQuery(url.getQuery(), charSet)).isEmpty() ? "" : "?" + sortQuery);
        return url.getProtocol() + "://" + url.getHost() + (String)(needsPort ? ":" + url.getPort() : "") + Utils.encodeURL(url.getPath()) + (String)(this.discardLinkURLAnchors || null == url.getRef() ? "" : "#" + Utils.encodeURL(url.getRef())) + (this.discardLinkURLQueries ? "" : Utils.encodeURL((String)query));
    }

    public static String sortQuery(String query, String charSet) throws UnsupportedEncodingException {
        List nvps = URLEncodedUtils.parse((String)query, (Charset)Charset.forName(charSet));
        TreeMap params = new TreeMap();
        for (NameValuePair nvp : nvps) {
            String name = nvp.getName();
            String value = nvp.getValue();
            if (null == name || null == value) continue;
            if (!params.containsKey(name)) {
                params.put(name, new ArrayList());
            }
            ((List)params.get(name)).add(value);
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (Map.Entry param : params.entrySet()) {
            String name = URLEncoder.encode((String)param.getKey(), charSet);
            List values = (List)param.getValue();
            Collections.sort(values);
            for (int j = 0; j < values.size(); ++j) {
                String value = (String)values.get(j);
                if (null == value) continue;
                sb.append(name).append("=").append(URLEncoder.encode(value, charSet));
                if (j >= values.size() - 1) continue;
                sb.append("&");
            }
            if (i < params.size() - 1) {
                sb.append("&");
            }
            ++i;
        }
        return sb.toString();
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.out.println("usage: java " + HttpLinkNormalizer.class.getName() + " <file-name>");
            System.exit(1);
        }
        HttpLinkNormalizer n = new HttpLinkNormalizer(false, false, false);
        try (BufferedReader br = new BufferedReader(new FileReader(args[0]));){
            String link;
            while (null != (link = br.readLine())) {
                System.out.println(n.normalize(link, "UTF-8"));
            }
        }
    }
}

