/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.connector.plugins.web.fetcher;

import com.google.inject.Inject;
import com.lucidworks.connector.plugins.web.WebConnectorException;
import com.lucidworks.connector.plugins.web.config.WebConfig;
import com.lucidworks.connector.plugins.web.fetcher.webdriver.WebDriverPool;
import java.time.Duration;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.NoSuchSessionException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.support.ui.WebDriverWait;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsEvaluator {
    @Generated
    private static final Logger logger = LoggerFactory.getLogger(JsEvaluator.class);
    private final WebDriverPool driverPool;
    private final WebConfig config;

    @Inject
    public JsEvaluator(WebConfig config, WebDriverPool driverPool) {
        this.driverPool = driverPool;
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String evaluateJs(String url) {
        int retryCount = 0;
        int MAX_RETRIES = 2;
        RemoteWebDriver driver = null;
        while (retryCount <= 2) {
            try {
                driver = this.driverPool.borrowDriver();
                if (url == null || url.isEmpty()) {
                    logger.warn("The URL is empty!");
                    String string = "";
                    return string;
                }
                logger.debug("Calling {} ", (Object)url);
                driver.get(url);
                if (BooleanUtils.isTrue((Boolean)this.config.properties().javascriptEvaluationConfig().waitForLateAjaxRequests())) {
                    this.handleWaitForLateAjaxRequests(driver);
                }
                String pageTitle = driver.getTitle();
                logger.debug("Page title: {}", (Object)pageTitle);
                String pageSource = driver.getPageSource();
                logger.debug("Page source length: " + pageSource.length());
                String string = pageSource;
                return string;
            }
            catch (Exception e) {
                this.driverPool.destroyDriver(driver);
                driver = null;
                if (++retryCount > 2) {
                    logger.error("Error evaluating JS on URL after {} retries: {}", new Object[]{2, url, e});
                    throw new WebConnectorException(e.getMessage(), e);
                }
                logger.warn("Error evaluating JS (attempt {}/{}), will retry: {}", new Object[]{retryCount, 2, e.getMessage()});
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
            }
            finally {
                if (driver == null) continue;
                this.driverPool.returnDriver(driver);
            }
        }
        throw new WebConnectorException("Failed to evaluate JS after retries");
    }

    public void close() {
        try {
            this.driverPool.shutdown();
        }
        catch (Exception exception) {
            logger.error("Error closing WebDriver: {}", (Object)exception.getMessage(), (Object)exception);
        }
    }

    private void handleWaitForLateAjaxRequests(RemoteWebDriver driver) {
        logger.debug("Injecting AJAX request counter");
        this.injectRequestCounter(driver);
        logger.debug("Waiting for page load");
        this.waitForPageLoad(driver);
        logger.debug("Waiting for AJAX completion");
        this.waitForAjaxCompletion(driver);
        logger.debug("Validating driver session after AJAX completion");
        this.validateSession(driver);
    }

    private void waitForPageLoad(RemoteWebDriver driver) {
        try {
            Integer jsPageLoadTimeout = this.config.properties().javascriptEvaluationConfig().jsPageLoadTimeout();
            int timeoutMs = jsPageLoadTimeout != null ? jsPageLoadTimeout : 15000;
            logger.debug("Waiting for page load to complete (timeout: {}ms)", (Object)timeoutMs);
            WebDriverWait wait = new WebDriverWait((WebDriver)driver, Duration.ofMillis(timeoutMs));
            wait.until(wd -> {
                String readyState = (String)((JavascriptExecutor)wd).executeScript("return document.readyState", new Object[0]);
                return "complete".equals(readyState);
            });
            logger.debug("Page load complete (document.readyState === 'complete')");
        }
        catch (Exception e) {
            logger.error("Page load wait failed: {}", (Object)e.getMessage());
        }
    }

    private void validateSession(RemoteWebDriver driver) {
        try {
            String sessionId = driver.getSessionId().toString();
            logger.debug("Validating session {} after AJAX completion", (Object)sessionId);
            driver.getCurrentUrl();
            logger.debug("Session validation successful for {}", (Object)sessionId);
        }
        catch (NoSuchSessionException e) {
            logger.error("Session no longer exists after AJAX completion: {}", (Object)e.getMessage());
            throw new WebConnectorException("WebDriver session became invalid during AJAX completion", e);
        }
        catch (WebDriverException e) {
            logger.error("WebDriver session error after AJAX completion: {}", (Object)e.getMessage());
            throw new WebConnectorException("WebDriver session error after AJAX completion", e);
        }
        catch (Exception e) {
            logger.error("Error after AJAX completion: {}", (Object)e.getMessage());
            throw new WebConnectorException("Error after AJAX completion", e);
        }
    }

    private void waitForAjaxCompletion(RemoteWebDriver driver) {
        try {
            Integer requestCounterMinWait = this.config.properties().javascriptEvaluationConfig().requestCounterMinWaitMs();
            int minWaitMs = requestCounterMinWait != null ? requestCounterMinWait : 500;
            Integer requestCounterMaxWait = this.config.properties().javascriptEvaluationConfig().requestCounterMaxWaitMs();
            int maxWaitMs = requestCounterMaxWait != null ? requestCounterMaxWait : 3000;
            logger.debug("AJAX completion detection - min: {}ms, max: {}ms", (Object)minWaitMs, (Object)maxWaitMs);
            long startTime = System.currentTimeMillis();
            boolean hasSeenActiveRequests = false;
            Thread.sleep(minWaitMs);
            while (System.currentTimeMillis() - startTime < (long)maxWaitMs) {
                Long activeRequests = (Long)driver.executeScript("return window.lucidworksRequestCounter ? window.lucidworksRequestCounter.getCount() : 0", new Object[0]);
                logger.debug("Active AJAX requests: {}", (Object)activeRequests);
                long currentElapsed = System.currentTimeMillis() - startTime;
                if (activeRequests > 0L) {
                    hasSeenActiveRequests = true;
                    logger.debug("Active AJAX requests: {} (elapsed: {}ms)", (Object)activeRequests, (Object)currentElapsed);
                } else {
                    if (hasSeenActiveRequests) {
                        logger.debug("All AJAX requests completed after {}ms", (Object)currentElapsed);
                        break;
                    }
                    if (currentElapsed > (long)minWaitMs) {
                        logger.debug("No AJAX requests detected after minimum wait period ({}ms)", (Object)currentElapsed);
                        break;
                    }
                }
                Thread.sleep(100L);
            }
            if (System.currentTimeMillis() - startTime >= (long)maxWaitMs) {
                logger.debug("AJAX completion wait timed out after {}ms", (Object)maxWaitMs);
            }
        }
        catch (InterruptedException e) {
            logger.warn("AJAX completion detection interrupted: {}", (Object)e.getMessage());
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            logger.error("AJAX completion detection failed: {}", (Object)e.getMessage());
        }
    }

    private void injectRequestCounter(RemoteWebDriver driver) {
        try {
            String requestCounterScript = "if (!window.lucidworksRequestCounter) {  window.lucidworksRequestCounter = {    activeRequests: 0,    increment: function() { this.activeRequests++; },    decrement: function() { this.activeRequests--; if (this.activeRequests < 0) this.activeRequests = 0; },    getCount: function() { return this.activeRequests; }  };  var originalXHROpen = XMLHttpRequest.prototype.open;  var originalXHRSend = XMLHttpRequest.prototype.send;  XMLHttpRequest.prototype.open = function() {    this._lucidworksTracked = true;    return originalXHROpen.apply(this, arguments);  };  XMLHttpRequest.prototype.send = function() {    if (this._lucidworksTracked) {      window.lucidworksRequestCounter.increment();      this.addEventListener('loadend', function() {        window.lucidworksRequestCounter.decrement();      });    }    return originalXHRSend.apply(this, arguments);  };  if (window.fetch) {    var originalFetch = window.fetch;    window.fetch = function() {      window.lucidworksRequestCounter.increment();      return originalFetch.apply(this, arguments).finally(function() {        window.lucidworksRequestCounter.decrement();      });    };  }}";
            driver.executeScript(requestCounterScript, new Object[0]);
            Boolean injected = (Boolean)driver.executeScript("return window.lucidworksRequestCounter !== undefined;", new Object[0]);
            if (Boolean.TRUE.equals(injected)) {
                logger.debug("Request counter JavaScript injected successfully");
            } else {
                logger.warn("Request counter injection verification failed");
            }
        }
        catch (Exception e) {
            logger.error("Failed to inject request counter: {}", (Object)e.getMessage());
        }
    }
}

