/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.connector.plugins.web.fetcher;

import com.google.inject.Inject;
import com.lucidworks.connector.plugins.web.WebConnectorException;
import com.lucidworks.connector.plugins.web.config.WebConfig;
import com.lucidworks.fusion.connector.plugin.api.exceptions.ContentEmitException;
import com.lucidworks.fusion.connector.plugin.api.fetcher.type.content.Content;
import com.lucidworks.fusion.connector.plugin.api.fetcher.type.content.ContentFetcher;
import com.lucidworks.fusion.connector.plugin.api.fetcher.type.content.Error;
import com.lucidworks.fusion.connector.plugin.api.fetcher.type.content.FetchInput;
import com.lucidworks.fusion.connector.plugin.api.fetcher.type.content.Skip;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Emitter {
    @Generated
    private static final Logger logger = LoggerFactory.getLogger(Emitter.class);
    private final WebConfig config;
    private final AtomicInteger emitCounter = new AtomicInteger();
    public static final String FAILURE_ALLOWANCE = "failureAllowance";
    public static final String ERROR = "error";
    public static final String LAST_EMITTED = "lastEmitted";

    @Inject
    public Emitter(WebConfig config) {
        this.config = config;
    }

    public void emitDelete(ContentFetcher.FetchContext context) {
        context.newDelete().emit();
    }

    public void emitError(ContentFetcher.FetchContext context, String id, String message, Map<String, Object> metadata) {
        metadata.put(LAST_EMITTED, this.getLastEmitted());
        metadata.put(ERROR, message);
        ((Error.Emitter)context.newError(id, message).metadata(m -> m.merge(metadata))).emit();
    }

    public void emitErrorOrDelete(ContentFetcher.FetchContext context, FetchInput input, String message) {
        Integer deleteErrorsAfter = this.config.properties().recrawlRulesConfig().deleteErrorsAfter();
        logger.info("deleteErrorsAfter {}", (Object)deleteErrorsAfter);
        if (deleteErrorsAfter < 0) {
            this.emitError(context, input.getId(), message, new HashMap<String, Object>());
            return;
        }
        HashMap<String, Object> metadata = new HashMap<String, Object>(input.getMetadata());
        int counter = deleteErrorsAfter;
        if (metadata.containsKey(FAILURE_ALLOWANCE)) {
            counter = Integer.parseInt(String.valueOf(metadata.get(FAILURE_ALLOWANCE)));
        }
        metadata.put(FAILURE_ALLOWANCE, --counter);
        logger.info("Failure allowance counter {}", (Object)counter);
        if (counter > -1) {
            this.emitError(context, input.getId(), message, metadata);
        } else {
            logger.info("Removing doc id {} due to fetch error ", (Object)input.getId());
            this.emitDelete(context);
        }
    }

    public void emitContent(ContentFetcher.FetchContext context, String id, InputStream is, Map<String, Object> fields, Map<String, Object> metadata) {
        try {
            if (this.isLimitReached()) {
                logger.warn("Content id {} is not emitted due to max items limit", (Object)id);
                return;
            }
            this.emitCounter.incrementAndGet();
            long lastEmitted = this.getLastEmitted();
            HashMap<String, Object> finalMetadata = new HashMap<String, Object>(metadata);
            finalMetadata.put(LAST_EMITTED, lastEmitted);
            ((Content.ContentEmitter)((Content.ContentEmitter)context.newContent(id, is).fields(m -> m.merge(fields))).metadata(m -> m.merge(finalMetadata))).emit();
        }
        catch (ContentEmitException e) {
            throw new WebConnectorException("Could not emit content stream", e);
        }
    }

    public void emitCandidate(ContentFetcher.FetchContext context, String id) {
        logger.info("Emitting candidate {}", (Object)id);
        context.newCandidate(id).emit();
    }

    public void emitSkip(ContentFetcher.FetchContext context) {
        HashMap<String, Long> metadata = new HashMap<String, Long>();
        metadata.put(LAST_EMITTED, this.getLastEmitted());
        ((Skip.Emitter)((Skip.Emitter)context.newSkip().addCondition("")).metadata(m -> m.merge(metadata))).emit();
    }

    public boolean isLimitReached() {
        return this.config.properties().limitDocumentsConfig().maxItems() > -1 && this.emitCounter.get() >= this.config.properties().limitDocumentsConfig().maxItems();
    }

    private long getLastEmitted() {
        return System.currentTimeMillis() / 1000L;
    }
}

