/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.connector.plugins.web.config;

import com.lucidworks.fusion.schema.Model;
import com.lucidworks.fusion.schema.SchemaAnnotations;
import java.util.List;

public interface LimitDocumentsConfig
extends Model {
    @SchemaAnnotations.Property(title="Max crawling depth", description="Maximum number of link levels to explore within a site.", order=1)
    @SchemaAnnotations.NumberSchema(defaultValue=-1.0)
    public Integer depth();

    @SchemaAnnotations.Property(title="Max items", description="Maximum number of documents to fetch. The default (-1) means no limit.", order=2)
    @SchemaAnnotations.NumberSchema(defaultValue=-1.0)
    public Integer maxItems();

    @SchemaAnnotations.Property(title="Excluded file extensions", description="File extensions that should not to be fetched. This will limit this datasource to all extensions except this list.", order=3)
    @SchemaAnnotations.ArraySchema
    @SchemaAnnotations.StringSchema
    public List<String> excludeExtensions();

    @SchemaAnnotations.Property(title="Exclusive regexes", description="Regular expressions for URI patterns to exclude. This will limit this datasource to only URIs that do not match the regular expression.", order=4)
    @SchemaAnnotations.ArraySchema
    @SchemaAnnotations.StringSchema
    public List<String> excludeRegexes();

    @SchemaAnnotations.Property(title="Included file extensions", description="File extensions to be fetched. This will limit this datasource to only these file extensions.", order=5)
    @SchemaAnnotations.ArraySchema
    @SchemaAnnotations.StringSchema
    public List<String> includeExtensions();

    @SchemaAnnotations.Property(title="Inclusive regexes", description="Regular expressions for URI patterns to include. This will limit this datasource to only URIs that match the regular expression.", order=6)
    @SchemaAnnotations.ArraySchema
    @SchemaAnnotations.StringSchema
    public List<String> includeRegexes();

    @SchemaAnnotations.Property(title="Max file size (bytes)", description="Maximum size, in bytes, of a document to fetch.", order=7)
    @SchemaAnnotations.NumberSchema(defaultValue=2.0E7)
    public Integer maxSizeBytes();

    @SchemaAnnotations.Property(title="Index discarded document metadata", description="Enable to index discarded document metadata", order=8, hints={"hidden"})
    @SchemaAnnotations.BooleanSchema
    public Boolean indexItemsDiscarded();
}

