/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.connector.plugins.web.config;

import com.google.auto.value.AutoValue;
import com.lucidworks.fusion.schema.Model;
import com.lucidworks.fusion.schema.SchemaAnnotations;
import java.util.List;

@AutoValue.Builder
public interface DocumentParsingConfig
extends Model {
    @SchemaAnnotations.Property(title="Default character set", description="Default character set to use when one is not declared in the HTTP headers.", order=1, hints={"advanced"})
    @SchemaAnnotations.StringSchema(defaultValue="UTF-8")
    public String defaultCharSet();

    @SchemaAnnotations.Property(title="Obey server-supplied charset", description="Use the encoding sent by the web server (if any) when parsing content. If unset, Fusion will try to guess the character set when parsing.", order=2, hints={"hidden"})
    @SchemaAnnotations.BooleanSchema(defaultValue=true)
    public Boolean obeyCharSet();

    @SchemaAnnotations.Property(title="Default MIME type", description="Default MIME type to use when one is not declared in the HTTP headers.", order=3, hints={"advanced"})
    @SchemaAnnotations.StringSchema(defaultValue="application/octet-stream")
    public String defaultMIMEType();

    @SchemaAnnotations.Property(title="Add trailing slash to link URLs", description="If true, a trailing '/' will be added to link URLs when the URL does not end in a dot ('.').", order=4, hints={"advanced"})
    @SchemaAnnotations.BooleanSchema
    public Boolean appendTrailingSlashToLinks();

    @SchemaAnnotations.Property(title="Scrape links before filtering", description="If true, links will be extracted from documents before any other document processing has ocurred. By default, links are extracted after all other document processing.", order=5, hints={"advanced"})
    @SchemaAnnotations.BooleanSchema
    public Boolean scrapeLinksBeforeFiltering();

    @SchemaAnnotations.Property(title="Tag fields", description="HTML tags of elements to put into their own field in the index. The field will have the same name as the tag.", order=6, hints={"advanced"})
    @SchemaAnnotations.ArraySchema
    @SchemaAnnotations.StringSchema
    public List<String> tagFields();

    @SchemaAnnotations.Property(title="Tag-ID fields", description="HTML tag IDs of elements to put into their own field in the index. The field will have the same name as the tag ID.", order=7, hints={"advanced"})
    @SchemaAnnotations.ArraySchema
    @SchemaAnnotations.StringSchema
    public List<String> tagIDFields();

    @SchemaAnnotations.Property(title="Tag-class fields", description="HTML tag classes of elements to put into their own field in the index. The field will have the same name as the tag class.", order=8, hints={"advanced"})
    @SchemaAnnotations.ArraySchema
    @SchemaAnnotations.StringSchema
    public List<String> tagClassFields();

    @SchemaAnnotations.Property(title="Jsoup selector fields", description="List of Jsoup selectors for elements to put into their separate field in the index. The field will have the same name as the element. Syntax for jsoup selectors is available at http://jsoup.org/apidocs/org/jsoup/select/Selector.html.", order=9, hints={"advanced"})
    @SchemaAnnotations.ArraySchema
    @SchemaAnnotations.StringSchema
    public List<String> selectorFields();

    @SchemaAnnotations.Property(title="Root elements to filter", description="Root HTML elements whose child elements will be used to extract content. By default 'body' and 'head' elements are already included.", order=10, hints={"advanced"})
    @SchemaAnnotations.ArraySchema
    @SchemaAnnotations.StringSchema
    public List<String> filteringRootTags();

    @SchemaAnnotations.Property(title="Jsoup inclusive selectors", description="Jsoup-formatted selectors for elements to include in the crawled content.", order=11, hints={"advanced"})
    @SchemaAnnotations.ArraySchema
    @SchemaAnnotations.StringSchema
    public List<String> includeSelectors();

    @SchemaAnnotations.Property(title="Included tags", description="HTML tag names of elements to include in the crawled content.", order=12, hints={"advanced"})
    @SchemaAnnotations.ArraySchema
    @SchemaAnnotations.StringSchema
    public List<String> includeTags();

    @SchemaAnnotations.Property(title="Included tag classes", description="HTML tag classes of elements to include in the crawled content.", order=13, hints={"advanced"})
    @SchemaAnnotations.ArraySchema
    @SchemaAnnotations.StringSchema
    public List<String> includeTagClasses();

    @SchemaAnnotations.Property(title="Included tag IDs", description="HTML tag IDs of elements to include in the crawled content.", order=14, hints={"advanced"})
    @SchemaAnnotations.ArraySchema
    @SchemaAnnotations.StringSchema
    public List<String> includeTagIDs();

    @SchemaAnnotations.Property(title="Jsoup exclusive selectors", description="Jsoup-formatted selectors for elements to exclude from the crawled content. Syntax for jsoup selectors is available at http://jsoup.org/apidocs/org/jsoup/select/Selector.html.", order=15, hints={"advanced"})
    @SchemaAnnotations.ArraySchema
    @SchemaAnnotations.StringSchema
    public List<String> excludeSelectors();

    @SchemaAnnotations.Property(title="Excluded tags", description="HTML tag names of elements to exclude from the crawled content.", order=16, hints={"advanced"})
    @SchemaAnnotations.ArraySchema
    @SchemaAnnotations.StringSchema
    public List<String> excludeTags();

    @SchemaAnnotations.Property(title="Excluded tag classes", description="HTML tag classes of elements to exclude from the crawled content.", order=17, hints={"advanced"})
    @SchemaAnnotations.ArraySchema
    @SchemaAnnotations.StringSchema
    public List<String> excludeTagClasses();

    @SchemaAnnotations.Property(title="Excluded tag IDs", description="HTML tag IDs of elements to exclude from the crawled content.", order=18, hints={"advanced"})
    @SchemaAnnotations.ArraySchema
    @SchemaAnnotations.StringSchema
    public List<String> excludeTagIDs();

    @SchemaAnnotations.Property(title="Custom XPath Link Selectors", description="By default, only standard anchor tags, iframe tags, frame tags, and link tags are fetched. This allows you to use one or more XPath expressions to parse links from custom places. Such as //option/@value", order=19)
    @SchemaAnnotations.ArraySchema
    @SchemaAnnotations.StringSchema
    public List<String> customLinkSelectors();
}

