/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.connector.plugins.web.config;

import com.lucidworks.fusion.schema.Model;
import com.lucidworks.fusion.schema.SchemaAnnotations;

public interface CrawlHistoryConfig
extends Model {
    @SchemaAnnotations.Property(title="Crawl database type", description="The type of crawl database to use, in-memory or on-disk.", order=1, hints={"hidden"})
    @SchemaAnnotations.StringSchema(defaultValue="on-disk")
    public String crawlDBType();

    @SchemaAnnotations.Property(title="Commit After This Many Items", description="Commit the crawlDB to disk after this many items have been received. A smaller number here will result in a slower crawl because of commits to disk being more frequent; conversely, a larger number here will cause a resumed job after a crash to need to recrawl more records.", order=2, hints={"hidden"})
    @SchemaAnnotations.NumberSchema(minimum=1.0, maximum=9999999.0, defaultValue=10000.0)
    public Integer commitAfterItems();

    @SchemaAnnotations.Property(title="Retain links in the crawldb", description="Set to true for links found during fetching to be stored in the crawldb. This increases precision in certain recrawl scenarios, but requires more memory and disk space.", order=3, hints={"hidden"})
    @SchemaAnnotations.BooleanSchema
    public Boolean retainOutlinks();

    @SchemaAnnotations.Property(title="Alias expiration", description="The number of crawls after which an alias will expire. The default is 1 crawl.", order=4, hints={"hidden"})
    @SchemaAnnotations.NumberSchema(defaultValue=1.0)
    public Integer aliasExpiration();

    @SchemaAnnotations.Property(title="Discard queries in link URLs", description="If true, query parameters found in URLs will be removed before being added to the discovery queue.", order=5, hints={"advanced"})
    @SchemaAnnotations.BooleanSchema
    public Boolean discardLinkURLQueries();

    @SchemaAnnotations.Property(title="Discard anchors in link URLs", description="If true, anchors found in URLs will be removed before being added to the discovery queue.", order=6, hints={"advanced"})
    @SchemaAnnotations.BooleanSchema
    public Boolean discardLinkURLAnchors();
}

