/*
 * Decompiled with CFR 0.152.
 */
package crawlercommons.sitemaps.sax;

import crawlercommons.sitemaps.AbstractSiteMap;
import crawlercommons.sitemaps.SiteMap;
import crawlercommons.sitemaps.SiteMapParser;
import crawlercommons.sitemaps.SiteMapURL;
import crawlercommons.sitemaps.sax.DelegatorHandler;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class XMLHandler
extends DelegatorHandler {
    private SiteMap sitemap;
    private StringBuilder loc;
    private String lastMod;
    private String changeFreq;
    private String priority;
    private int i = 0;
    private boolean currentElementNamespaceIsValid;

    XMLHandler(URL url, LinkedList<String> elementStack, boolean strict) {
        super(elementStack, strict);
        this.sitemap = new SiteMap(url);
        this.sitemap.setType(AbstractSiteMap.SitemapType.XML);
        this.loc = new StringBuilder();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.isStrictNamespace() && !this.isAcceptedNamespace(uri)) {
            SiteMapParser.LOG.debug("Skip element <{}>, namespace <{}> not accepted", (Object)localName, (Object)uri);
            this.currentElementNamespaceIsValid = false;
            return;
        }
        this.currentElementNamespaceIsValid = true;
        if (this.loc.length() > 0 && ("loc".equals(localName) || "url".equals(localName))) {
            for (int i = 0; i < this.loc.length(); ++i) {
                if (Character.isWhitespace(this.loc.charAt(i))) continue;
                this.maybeAddSiteMapUrl();
                return;
            }
            this.loc = new StringBuilder();
            if ("url".equals(localName)) {
                this.lastMod = null;
                this.changeFreq = null;
                this.priority = null;
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.isStrictNamespace() && !this.isAcceptedNamespace(uri)) {
            return;
        }
        if ("url".equals(localName) && "urlset".equals(this.currentElementParent())) {
            this.maybeAddSiteMapUrl();
        } else if ("urlset".equals(localName)) {
            this.sitemap.setProcessed(true);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.isStrictNamespace() && !this.currentElementNamespaceIsValid) {
            return;
        }
        String localName = super.currentElement();
        String value = String.valueOf(ch, start, length);
        if ("loc".equals(localName) || "url".equals(localName)) {
            this.loc.append(value);
        } else if ("changefreq".equals(localName)) {
            this.changeFreq = value;
        } else if ("lastmod".equals(localName)) {
            this.lastMod = value;
        } else if ("priority".equals(localName)) {
            this.priority = value;
        }
    }

    @Override
    public AbstractSiteMap getSiteMap() {
        return this.sitemap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeAddSiteMapUrl() {
        String value = this.loc.toString().trim();
        try {
            URL locURL = new URL(value);
            boolean valid = SiteMapParser.urlIsValid(this.sitemap.getBaseUrl(), value);
            if (valid || !this.isStrict()) {
                SiteMapURL sUrl = new SiteMapURL(locURL, valid);
                sUrl.setLastModified(this.lastMod);
                sUrl.setChangeFrequency(this.changeFreq);
                sUrl.setPriority(this.priority);
                this.sitemap.addSiteMapUrl(sUrl);
                SiteMapParser.LOG.debug("  {}. {}", (Object)(++this.i), (Object)sUrl);
            }
        }
        catch (MalformedURLException e) {
            SiteMapParser.LOG.debug("Bad url: [{}]", (Object)value);
            SiteMapParser.LOG.trace("Can't create an entry with a bad URL", (Throwable)e);
        }
        finally {
            this.loc = new StringBuilder();
            this.lastMod = null;
            this.changeFreq = null;
            this.priority = null;
        }
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        this.maybeAddSiteMapUrl();
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        this.maybeAddSiteMapUrl();
    }
}

