/*
 * Decompiled with CFR 0.152.
 */
package crawlercommons.sitemaps;

import crawlercommons.sitemaps.AbstractSiteMap;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SiteMapIndex
extends AbstractSiteMap {
    private List<AbstractSiteMap> sitemaps = new ArrayList<AbstractSiteMap>();

    public SiteMapIndex() {
    }

    public SiteMapIndex(URL url) {
        this();
        this.url = url;
    }

    public Collection<AbstractSiteMap> getSitemaps() {
        return this.sitemaps;
    }

    public void addSitemap(AbstractSiteMap sitemap) {
        this.sitemaps.add(sitemap);
    }

    public AbstractSiteMap getSitemap(URL url) {
        for (AbstractSiteMap asm : this.sitemaps) {
            if (!asm.getUrl().equals(url)) continue;
            return asm;
        }
        return null;
    }

    public boolean hasUnprocessedSitemap() {
        return this.nextUnprocessedSitemap() != null;
    }

    public AbstractSiteMap nextUnprocessedSitemap() {
        for (AbstractSiteMap asm : this.sitemaps) {
            if (asm.isProcessed()) continue;
            return asm;
        }
        return null;
    }

    @Override
    public boolean isIndex() {
        return true;
    }

    public String toString() {
        return "url = \"" + this.url + "\", sitemapListSize = " + this.sitemaps.size();
    }
}

