/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.connectors.components.processor.model.gson;

import com.lucidworks.fusion.connector.plugin.api.fetcher.type.builders.MapBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapBuilderHelper {
    private static final Logger logger = LoggerFactory.getLogger(MapBuilderHelper.class);

    private MapBuilderHelper() {
    }

    public static Consumer<MapBuilder> toMapBuilder(Map<String, Object> map) {
        return m -> map.forEach((k, v) -> {
            if (v instanceof Double) {
                m.setDouble(k, (Double)v);
            } else if (v instanceof String) {
                m.setString(k, (String)v);
            } else if (v instanceof Boolean) {
                m.setBoolean(k, (Boolean)v);
            } else if (v instanceof Date) {
                m.setDate(k, (Date)v);
            } else if (v instanceof Float) {
                m.setFloat(k, (Float)v);
            } else if (v instanceof Long) {
                m.setLong(k, (Long)v);
            } else if (v instanceof Integer) {
                m.setInteger(k, (Integer)v);
            } else if (v instanceof Collection) {
                ArrayList list = new ArrayList((Collection)v);
                m.setStrings(k, list);
            } else {
                logger.warn("Metadata with key={} not added", k);
            }
        });
    }
}

