/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.core;

import io.github.resilience4j.core.ContextPropagator;
import io.github.resilience4j.core.NamingThreadFactory;
import io.github.resilience4j.core.lang.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.MDC;

public class ContextAwareScheduledThreadPoolExecutor
extends ScheduledThreadPoolExecutor {
    private final List<ContextPropagator> contextPropagators;
    private static final String THREAD_PREFIX = "ContextAwareScheduledThreadPool";

    private ContextAwareScheduledThreadPoolExecutor(int corePoolSize, @Nullable List<ContextPropagator> contextPropagators) {
        super(corePoolSize, new NamingThreadFactory(THREAD_PREFIX));
        this.contextPropagators = contextPropagators != null ? contextPropagators : new ArrayList();
    }

    public List<ContextPropagator> getContextPropagators() {
        return Collections.unmodifiableList(this.contextPropagators);
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        Map<String, String> mdcContextMap = this.getMdcContextMap();
        return super.schedule(ContextPropagator.decorateRunnable(this.contextPropagators, () -> {
            try {
                this.setMDCContext(mdcContextMap);
                command.run();
            }
            finally {
                MDC.clear();
            }
        }), delay, unit);
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        Map<String, String> mdcContextMap = this.getMdcContextMap();
        return super.schedule(ContextPropagator.decorateCallable(this.contextPropagators, () -> {
            try {
                this.setMDCContext(mdcContextMap);
                Object v = callable.call();
                return v;
            }
            finally {
                MDC.clear();
            }
        }), delay, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        Map<String, String> mdcContextMap = this.getMdcContextMap();
        return super.scheduleAtFixedRate(ContextPropagator.decorateRunnable(this.contextPropagators, () -> {
            try {
                this.setMDCContext(mdcContextMap);
                command.run();
            }
            finally {
                MDC.clear();
            }
        }), initialDelay, period, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        Map<String, String> mdcContextMap = this.getMdcContextMap();
        return super.scheduleWithFixedDelay(ContextPropagator.decorateRunnable(this.contextPropagators, () -> {
            try {
                this.setMDCContext(mdcContextMap);
                command.run();
            }
            finally {
                MDC.clear();
            }
        }), initialDelay, delay, unit);
    }

    private Map<String, String> getMdcContextMap() {
        return Optional.ofNullable(MDC.getCopyOfContextMap()).orElse(Collections.emptyMap());
    }

    private void setMDCContext(Map<String, String> contextMap) {
        MDC.clear();
        if (contextMap != null) {
            MDC.setContextMap(contextMap);
        }
    }

    public static Builder newScheduledThreadPool() {
        return new Builder();
    }

    public static class Builder {
        private List<ContextPropagator> contextPropagators = new ArrayList<ContextPropagator>();
        private int corePoolSize;

        public Builder corePoolSize(int corePoolSize) {
            if (corePoolSize < 1) {
                throw new IllegalArgumentException("corePoolSize must be a positive integer value >= 1");
            }
            this.corePoolSize = corePoolSize;
            return this;
        }

        public Builder contextPropagators(ContextPropagator ... contextPropagators) {
            this.contextPropagators = contextPropagators != null ? Arrays.stream(contextPropagators).collect(Collectors.toList()) : new ArrayList<ContextPropagator>();
            return this;
        }

        public ContextAwareScheduledThreadPoolExecutor build() {
            return new ContextAwareScheduledThreadPoolExecutor(this.corePoolSize, this.contextPropagators);
        }
    }
}

