/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.connector.plugins.solr.validation;

import com.lucidworks.connector.plugins.solr.client.SolrClientHelper;
import com.lucidworks.connector.plugins.solr.client.SolrClientProvider;
import com.lucidworks.connector.plugins.solr.config.AdvancedSolrConnectionProperties;
import com.lucidworks.connector.plugins.solr.config.SolrConfig;
import com.lucidworks.connector.plugins.solr.config.SolrConnectionProperties;
import com.lucidworks.connector.plugins.solr.config.SolrQueryProperties;
import com.lucidworks.connector.plugins.solr.validation.ValidationQueryResult;
import com.lucidworks.fusion.connector.plugin.api.config.ConnectorConfig;
import com.lucidworks.fusion.connector.plugin.api.validation.ValidationComponent;
import com.lucidworks.fusion.connector.plugin.api.validation.ValidationContext;
import com.lucidworks.fusion.connector.plugin.api.validation.result.ConnectorConfigValidationResult;
import com.lucidworks.fusion.schema.ValidationError;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import lombok.Generated;
import org.apache.solr.client.solrj.SolrClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrConfigurationValidator
implements ValidationComponent {
    @Generated
    private static final Logger logger = LoggerFactory.getLogger(SolrConfigurationValidator.class);
    private final SolrConfig config;
    private final SolrClientProvider clientProvider;
    private final SolrClientHelper helper;

    @Inject
    public SolrConfigurationValidator(SolrConfig config, SolrClientProvider clientProvider, SolrClientHelper helper) {
        this.config = config;
        this.clientProvider = clientProvider;
        this.helper = helper;
    }

    public ConnectorConfigValidationResult validateConfig(ValidationContext context) {
        ConnectorConfigValidationResult.Builder resultBuilder = ConnectorConfigValidationResult.builder((ConnectorConfig)this.config);
        try {
            this.validateConnectionProperties(resultBuilder);
            this.validateQueryProperties(resultBuilder);
            this.testConnectionAndQuery(resultBuilder);
        }
        catch (Exception e) {
            logger.error("Unexpected error during validation", (Throwable)e);
            resultBuilder.withErrors((Object[])new ValidationError[]{new ValidationError("connection", (Object)"", "value-not-allowed", "Validation failed due to unexpected error: " + e.getMessage())});
        }
        return resultBuilder.build();
    }

    private void validateConnectionProperties(ConnectorConfigValidationResult.Builder resultBuilder) {
        AdvancedSolrConnectionProperties advancedConnection;
        boolean hasSolrUrl;
        SolrConnectionProperties connection = this.config.properties().connection();
        boolean hasZkHosts = connection.zkHosts() != null && !connection.zkHosts().trim().isEmpty();
        boolean bl = hasSolrUrl = connection.solrUrl() != null && !connection.solrUrl().trim().isEmpty();
        if (!hasZkHosts && !hasSolrUrl) {
            resultBuilder.withErrors((Object[])new ValidationError[]{new ValidationError("connection", (Object)"", "value-required", "Exactly one of ZooKeeper hosts or Solr URL must be specified")});
        } else if (hasZkHosts && hasSolrUrl) {
            resultBuilder.withErrors((Object[])new ValidationError[]{new ValidationError("connection", (Object)"", "value-not-allowed", "Cannot specify both ZooKeeper hosts and Solr URL - choose one connection method")});
        }
        String connectionType = connection.connectionType();
        if ("SOLRCLOUD".equals(connectionType)) {
            if (!hasZkHosts) {
                resultBuilder.withErrors((Object[])new ValidationError[]{new ValidationError("connection.zkHosts", (Object)"", "value-required", "ZooKeeper hosts are required for SolrCloud connections")});
            }
            if (connection.collection() == null || connection.collection().trim().isEmpty()) {
                resultBuilder.withErrors((Object[])new ValidationError[]{new ValidationError("connection.collection", (Object)"", "value-required", "Collection name is required for SolrCloud")});
            }
        } else if ("STANDALONE".equals(connectionType)) {
            if (!hasSolrUrl) {
                resultBuilder.withErrors((Object[])new ValidationError[]{new ValidationError("connection.solrUrl", (Object)"", "value-required", "Solr URL is required for standalone connections")});
            }
            if (hasSolrUrl) {
                try {
                    new URI(connection.solrUrl());
                }
                catch (URISyntaxException e) {
                    resultBuilder.withErrors((Object[])new ValidationError[]{new ValidationError("connection.solrUrl", (Object)connection.solrUrl(), "invalid-url", "Invalid Solr server URL: " + e.getMessage())});
                }
            }
        }
        if ((advancedConnection = this.config.properties().advancedConnection()).connectionTimeoutMs() != null && advancedConnection.socketTimeoutMs() != null && advancedConnection.connectionTimeoutMs() > advancedConnection.socketTimeoutMs()) {
            resultBuilder.withErrors((Object[])new ValidationError[]{new ValidationError("advancedConnection.connectionTimeoutMs", (Object)advancedConnection.connectionTimeoutMs().toString(), "number-too-large", "Connection timeout should not be greater than socket timeout")});
        }
    }

    private void validateQueryProperties(ConnectorConfigValidationResult.Builder resultBuilder) {
        SolrQueryProperties query = this.config.properties().query();
        if (query.sort() != null && !query.sort().trim().isEmpty()) {
            this.validateSortSpecification(query.sort(), resultBuilder);
        }
        if (query.sort() != null && !query.sort().trim().isEmpty() && query.fieldList() != null && !query.fieldList().trim().isEmpty()) {
            this.validateSortFieldsInFieldList(query.sort(), query.fieldList(), resultBuilder);
        }
        if (query.filterQueries() != null && !query.filterQueries().isEmpty()) {
            this.validateFilterQueries(query.filterQueries(), resultBuilder);
        }
        if (query.queryParser() != null && !query.queryParser().trim().isEmpty()) {
            logger.warn("If a relevancy query parser is used, ensure score desc is included in sort to avoid unexpected ranking.");
            this.validateQueryParser(query.queryParser());
        }
        if (query.requestHandler() != null && !query.requestHandler().trim().isEmpty()) {
            this.validateRequestHandler(query.requestHandler(), resultBuilder);
        }
    }

    private void validateSortSpecification(String sortSpec, ConnectorConfigValidationResult.Builder resultBuilder) {
        String[] sortClauses;
        for (String clause : sortClauses = sortSpec.split(",")) {
            String trimmed = clause.trim();
            if (trimmed.isEmpty()) continue;
            this.validateSortClause(trimmed, resultBuilder);
        }
    }

    private void validateSortClause(String trimmed, ConnectorConfigValidationResult.Builder resultBuilder) {
        String[] parts = trimmed.split("\\s+");
        if (parts.length > 2) {
            resultBuilder.withErrors((Object[])new ValidationError[]{new ValidationError("query.sort", (Object)trimmed, "value-not-allowed", "Invalid sort clause: '" + trimmed + "'. Expected format: 'field' or 'field asc|desc'")});
        } else if (parts.length == 2) {
            this.validateSortDirection(trimmed, parts[1], resultBuilder);
        }
    }

    private void validateSortDirection(String trimmed, String direction, ConnectorConfigValidationResult.Builder resultBuilder) {
        boolean isValid;
        String lowerDirection = direction.toLowerCase();
        boolean bl = isValid = "asc".equals(lowerDirection) || "desc".equals(lowerDirection) || "ascending".equals(lowerDirection) || "descending".equals(lowerDirection);
        if (!isValid) {
            resultBuilder.withErrors((Object[])new ValidationError[]{new ValidationError("query.sort", (Object)trimmed, "value-not-allowed", "Invalid sort direction: '" + direction + "'. Use 'asc', 'desc', 'ascending', or 'descending'")});
        }
    }

    private void validateSortFieldsInFieldList(String sortSpec, String fieldList, ConnectorConfigValidationResult.Builder resultBuilder) {
        if (fieldList.contains("*")) {
            return;
        }
        Set<String> fields = Arrays.stream(fieldList.split(",")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toSet());
        List<String> missingSortFields = this.findMissingSortFields(sortSpec, fields);
        if (!missingSortFields.isEmpty()) {
            resultBuilder.withErrors((Object[])new ValidationError[]{new ValidationError("query.sort", (Object)sortSpec, "value-not-allowed", String.format("Sort fields must be included in field list. Missing fields: %s. Either add these fields to 'Field List To Retrieve' or use '*' to return all fields.", String.join((CharSequence)", ", missingSortFields)))});
        }
    }

    private List<String> findMissingSortFields(String sortSpec, Set<String> fields) {
        String[] sortClauses;
        ArrayList<String> missingSortFields = new ArrayList<String>();
        for (String clause : sortClauses = sortSpec.split(",")) {
            boolean isFieldMissing;
            String trimmed = clause.trim();
            if (trimmed.isEmpty()) continue;
            String sortField = trimmed.split("\\s+")[0];
            boolean isSpecialField = "score".equals(sortField);
            boolean bl = isFieldMissing = !fields.contains(sortField);
            if (isSpecialField || !isFieldMissing) continue;
            missingSortFields.add(sortField);
        }
        return missingSortFields;
    }

    private void validateFilterQueries(List<String> filterQueries, ConnectorConfigValidationResult.Builder resultBuilder) {
        for (int i = 0; i < filterQueries.size(); ++i) {
            String fq = filterQueries.get(i);
            if (fq == null || fq.trim().isEmpty()) continue;
            this.validateSingleFilterQuery(fq, i, resultBuilder);
        }
    }

    private void validateSingleFilterQuery(String fq, int index, ConnectorConfigValidationResult.Builder resultBuilder) {
        String trimmed = fq.trim();
        if ("*".equals(trimmed)) {
            resultBuilder.withErrors((Object[])new ValidationError[]{new ValidationError("query.filterQueries[" + index + "]", (Object)fq, "value-not-allowed", "Invalid filter query syntax of '*'. Use field:value format")});
        }
    }

    private void validateQueryParser(String queryParser) {
        String trimmed = queryParser.trim().toLowerCase();
        if (!this.isValidQueryParser(trimmed)) {
            logger.warn("Unknown query parser: {}. Common parsers: lucene, dismax, edismax, boost, simple", (Object)queryParser);
        }
    }

    private void validateRequestHandler(String requestHandler, ConnectorConfigValidationResult.Builder resultBuilder) {
        String trimmed = requestHandler.trim();
        if (!trimmed.startsWith("/")) {
            resultBuilder.withErrors((Object[])new ValidationError[]{new ValidationError("query.requestHandler", (Object)requestHandler, "value-not-allowed", "Request handler must start with '/': " + requestHandler)});
        }
    }

    private boolean isValidQueryParser(String queryParser) {
        return "lucene".equals(queryParser) || "complexphrase".equals(queryParser) || "dismax".equals(queryParser) || "edismax".equals(queryParser) || "boost".equals(queryParser) || "simple".equals(queryParser) || "func".equals(queryParser) || "frange".equals(queryParser) || "prefix".equals(queryParser) || "raw".equals(queryParser) || "term".equals(queryParser) || "nested".equals(queryParser) || "parent".equals(queryParser) || "child".equals(queryParser);
    }

    private void testConnectionAndQuery(ConnectorConfigValidationResult.Builder resultBuilder) {
        logger.info("Testing Solr connection and query configuration...");
        SolrConnectionProperties connectionProps = this.config.properties().connection();
        SolrQueryProperties queryProps = this.config.properties().query();
        try (SolrClient validationClient = this.clientProvider.getValidationClient();){
            logger.debug("Created validation client with 10-second timeout");
            ValidationQueryResult result = this.helper.testQuery(validationClient, connectionProps, queryProps);
            if (!result.isSuccess()) {
                resultBuilder.withErrors((Object[])new ValidationError[]{new ValidationError("query", (Object)"", "value-not-allowed", result.getErrorMessage())});
            } else {
                logger.info("Solr connection and query validation successful");
            }
        }
        catch (Exception e) {
            logger.error("Connection and query test failed", (Throwable)e);
            resultBuilder.withErrors((Object[])new ValidationError[]{new ValidationError("connection", (Object)"", "value-not-allowed", "Connection or query test failed: " + e.getMessage())});
        }
    }
}

