/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.connector.plugins.solr.util;

import com.lucidworks.connector.plugins.solr.config.AdvancedSolrQueryProperties;
import com.lucidworks.connector.plugins.solr.config.SolrQueryProperties;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Singleton;
import lombok.Generated;
import org.apache.solr.client.solrj.SolrQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SolrQueryBuilder {
    @Generated
    private static final Logger logger = LoggerFactory.getLogger(SolrQueryBuilder.class);
    public static final boolean DEFAULT_USE_CURSOR_MARK = true;

    public SolrQuery buildInitialQuery(SolrQueryProperties queryProps) {
        return this.buildInitialQuery(queryProps, null);
    }

    public SolrQuery buildInitialQuery(SolrQueryProperties queryProps, AdvancedSolrQueryProperties advancedProps) {
        SolrQuery query = new SolrQuery();
        query.setQuery(queryProps.query());
        this.addFilterQueries(query, queryProps.filterQueries());
        this.applySort(query, queryProps.sort());
        this.applyFieldList(query, queryProps.fieldList());
        this.applyQueryParser(query, queryProps.queryParser());
        query.setRows(queryProps.batchSize());
        query.setRequestHandler(queryProps.requestHandler());
        this.configurePagination(query, queryProps, advancedProps);
        logger.info("Built Solr query: {}", (Object)query.toString());
        return query;
    }

    private void addFilterQueries(SolrQuery query, List<String> filterQueries) {
        if (filterQueries == null || filterQueries.isEmpty()) {
            return;
        }
        for (String fq : filterQueries) {
            if (fq == null || fq.trim().isEmpty()) continue;
            query.addFilterQuery(new String[]{fq.trim()});
        }
    }

    private void applySort(SolrQuery query, String sort) {
        if (sort == null || sort.trim().isEmpty()) {
            return;
        }
        this.applySortToQuery(query, sort.trim());
    }

    private void applyFieldList(SolrQuery query, String fieldList) {
        if (fieldList == null || fieldList.trim().isEmpty()) {
            return;
        }
        String trimmedFieldList = fieldList.trim();
        String correctedFieldList = this.ensureIdFieldInList(trimmedFieldList);
        query.setFields(new String[]{correctedFieldList});
    }

    private String ensureIdFieldInList(String fieldList) {
        if (fieldList.contains("*")) {
            return fieldList;
        }
        Set fields = Arrays.stream(fieldList.split(",")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toSet());
        if (fields.contains("id")) {
            return fieldList;
        }
        logger.debug("Auto-added 'id' field to field list: {}", (Object)fieldList);
        return fieldList + ",id";
    }

    private void applyQueryParser(SolrQuery query, String queryParser) {
        if (queryParser == null || queryParser.trim().isEmpty()) {
            return;
        }
        query.set("defType", new String[]{queryParser.trim()});
        logger.debug("Set query parser: {}", (Object)queryParser);
    }

    private void configurePagination(SolrQuery query, SolrQueryProperties queryProps, AdvancedSolrQueryProperties advancedProps) {
        boolean useCursorMark = this.shouldUseCursorMark(advancedProps);
        if (useCursorMark) {
            this.configureCursorMarkPagination(query, queryProps);
        } else {
            this.configureOffsetPagination(query);
        }
    }

    private boolean shouldUseCursorMark(AdvancedSolrQueryProperties advancedProps) {
        if (advancedProps == null || advancedProps.useCursorMark() == null) {
            return true;
        }
        return advancedProps.useCursorMark();
    }

    private void configureCursorMarkPagination(SolrQuery query, SolrQueryProperties queryProps) {
        this.ensureUniqueKeyInSort(query, queryProps);
        query.set("cursorMark", new String[]{"*"});
        logger.info("Initialized cursor mark pagination");
    }

    private void ensureUniqueKeyInSort(SolrQuery query, SolrQueryProperties queryProps) {
        boolean hasSortSpecified;
        String sort = queryProps.sort();
        boolean bl = hasSortSpecified = sort != null && !sort.trim().isEmpty();
        if (!hasSortSpecified) {
            query.addSort("id", SolrQuery.ORDER.asc);
            logger.info("Cursor mark pagination requires sort - added default: id asc");
            return;
        }
        if (!this.sortContainsUniqueKey(query)) {
            query.addSort("id", SolrQuery.ORDER.asc);
            logger.info("Added 'id asc' to user-specified sort '{}' to ensure cursor mark compatibility", (Object)sort);
        }
    }

    private void configureOffsetPagination(SolrQuery query) {
        query.setStart(Integer.valueOf(0));
        logger.info("Initialized offset pagination");
    }

    public SolrQuery buildNextQuery(SolrQuery baseQuery, String nextCursorMark, int nextOffset) {
        SolrQuery nextQuery = baseQuery.getCopy();
        if (nextCursorMark != null) {
            nextQuery.set("cursorMark", new String[]{nextCursorMark});
            logger.debug("Set next cursor mark: {}", (Object)nextCursorMark);
        } else {
            nextQuery.setStart(Integer.valueOf(nextOffset));
            logger.debug("Set next offset: {}", (Object)nextOffset);
        }
        return nextQuery;
    }

    private void applySortToQuery(SolrQuery query, String sortSpec) {
        String[] sortClauses;
        for (String sortClause : sortClauses = sortSpec.split(",")) {
            String trimmedClause = sortClause.trim();
            if (trimmedClause.isEmpty()) continue;
            String[] sortParts = trimmedClause.split("\\s+");
            if (sortParts.length == 1) {
                query.addSort(sortParts[0], SolrQuery.ORDER.asc);
                continue;
            }
            if (sortParts.length < 2) continue;
            String field = sortParts[0];
            String direction = sortParts[1].toLowerCase();
            if ("desc".equals(direction) || "descending".equals(direction)) {
                query.addSort(field, SolrQuery.ORDER.desc);
                continue;
            }
            query.addSort(field, SolrQuery.ORDER.asc);
        }
    }

    private boolean sortContainsUniqueKey(SolrQuery query) {
        List sortClauses = query.getSorts();
        if (sortClauses == null || sortClauses.isEmpty()) {
            return false;
        }
        for (SolrQuery.SortClause sortClause : sortClauses) {
            String sortField = sortClause.getItem();
            if (!"id".equals(sortField)) continue;
            return true;
        }
        return false;
    }
}

