/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.connector.plugins.solr.resilience;

import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.CircuitBreakerConfig;
import io.github.resilience4j.core.IntervalFunction;
import io.github.resilience4j.retry.Retry;
import io.github.resilience4j.retry.RetryConfig;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.time.Duration;
import java.util.concurrent.TimeoutException;
import javax.inject.Inject;
import lombok.Generated;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.common.SolrException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrResilienceFactory {
    @Generated
    private static final Logger logger = LoggerFactory.getLogger(SolrResilienceFactory.class);
    private final Retry queryRetry = this.createRetryPolicy();
    private final CircuitBreaker queryCircuitBreaker = this.createCircuitBreaker();

    @Inject
    public SolrResilienceFactory() {
    }

    private Retry createRetryPolicy() {
        RetryConfig config = RetryConfig.custom().maxAttempts(3).intervalFunction(IntervalFunction.ofExponentialBackoff((long)1000L, (double)2.0)).retryOnException(this::shouldRetry).failAfterMaxAttempts(true).writableStackTraceEnabled(true).build();
        Retry retry = Retry.of((String)"solr-query", (RetryConfig)config);
        retry.getEventPublisher().onRetry(event -> logger.warn("Retry attempt {} for Solr query after {}ms wait", (Object)event.getNumberOfRetryAttempts(), (Object)event.getWaitInterval().toMillis())).onError(event -> logger.error("Solr query failed after {} retry attempts", (Object)event.getNumberOfRetryAttempts())).onSuccess(event -> {
            if (event.getNumberOfRetryAttempts() > 0) {
                logger.info("Solr query succeeded after {} retry attempts", (Object)event.getNumberOfRetryAttempts());
            }
        });
        return retry;
    }

    private CircuitBreaker createCircuitBreaker() {
        CircuitBreakerConfig config = CircuitBreakerConfig.custom().slidingWindowType(CircuitBreakerConfig.SlidingWindowType.COUNT_BASED).slidingWindowSize(10).failureRateThreshold(50.0f).waitDurationInOpenState(Duration.ofSeconds(30L)).slowCallDurationThreshold(Duration.ofSeconds(5L)).slowCallRateThreshold(50.0f).permittedNumberOfCallsInHalfOpenState(3).automaticTransitionFromOpenToHalfOpenEnabled(true).recordExceptions(new Class[]{SolrServerException.class, SocketTimeoutException.class, TimeoutException.class, IOException.class}).ignoreExceptions(new Class[]{IllegalArgumentException.class, IllegalStateException.class}).build();
        CircuitBreaker circuitBreaker = CircuitBreaker.of((String)"solr-query", (CircuitBreakerConfig)config);
        circuitBreaker.getEventPublisher().onStateTransition(event -> logger.info("Circuit breaker state transition: {} -> {}", (Object)event.getStateTransition().getFromState(), (Object)event.getStateTransition().getToState())).onCallNotPermitted(event -> logger.warn("Circuit breaker is OPEN - query rejected to prevent cascade failure")).onError(event -> logger.debug("Circuit breaker recorded error: {}", (Object)event.getThrowable().getMessage()));
        return circuitBreaker;
    }

    boolean shouldRetry(Throwable throwable) {
        if (throwable instanceof SocketTimeoutException || throwable instanceof TimeoutException || throwable instanceof IOException) {
            logger.debug("Retrying due to network/timeout issue: {}", (Object)throwable.getClass().getSimpleName());
            return true;
        }
        if (throwable instanceof SolrServerException) {
            SolrServerException sse = (SolrServerException)throwable;
            Throwable rootCause = sse.getRootCause();
            if (rootCause instanceof IOException) {
                logger.debug("Retrying due to SolrServerException with IOException root cause");
                return true;
            }
            logger.debug("Not retrying SolrServerException - root cause: {}", (Object)(rootCause != null ? rootCause.getClass().getSimpleName() : "none"));
            return false;
        }
        if (throwable instanceof SolrException) {
            SolrException se = (SolrException)throwable;
            boolean shouldRetry = se.code() >= 500;
            logger.debug("SolrException with code {} - retry: {}", (Object)se.code(), (Object)shouldRetry);
            return shouldRetry;
        }
        logger.debug("Not retrying exception type: {}", (Object)throwable.getClass().getSimpleName());
        return false;
    }

    public Retry getQueryRetry() {
        return this.queryRetry;
    }

    public CircuitBreaker getQueryCircuitBreaker() {
        return this.queryCircuitBreaker;
    }
}

