/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.connector.plugins.solr.resilience;

import com.lucidworks.connector.plugins.solr.exceptions.QueryExecutionException;
import com.lucidworks.connector.plugins.solr.resilience.SolrResilienceFactory;
import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.retry.Retry;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import javax.inject.Inject;
import lombok.Generated;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.params.SolrParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResilientSolrQueryExecutor {
    @Generated
    private static final Logger logger = LoggerFactory.getLogger(ResilientSolrQueryExecutor.class);
    private final SolrResilienceFactory resilienceFactory;

    @Inject
    public ResilientSolrQueryExecutor(SolrResilienceFactory resilienceFactory) {
        this.resilienceFactory = resilienceFactory;
    }

    public QueryResponse executeWithResilience(SolrClient client, String collection, SolrQuery query) throws SolrServerException, IOException {
        logger.debug("Executing Solr query with resilience - Collection: {}, Query: {}, Timeout: {}ms", new Object[]{collection, query.getQuery(), query.getTimeAllowed()});
        Supplier<QueryResponse> querySupplier = () -> {
            try {
                if (collection != null && !collection.isEmpty()) {
                    return client.query(collection, (SolrParams)query);
                }
                return client.query((SolrParams)query);
            }
            catch (IOException | SolrServerException e) {
                throw new QueryExecutionException(e);
            }
        };
        Supplier decoratedSupplier = CircuitBreaker.decorateSupplier((CircuitBreaker)this.resilienceFactory.getQueryCircuitBreaker(), (Supplier)Retry.decorateSupplier((Retry)this.resilienceFactory.getQueryRetry(), querySupplier));
        try {
            QueryResponse response = (QueryResponse)decoratedSupplier.get();
            logger.debug("Query executed successfully (possibly after retries)");
            return response;
        }
        catch (QueryExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof SolrServerException) {
                throw (SolrServerException)cause;
            }
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw new SolrServerException("Unexpected error during query execution", cause);
        }
    }

    public CompletableFuture<QueryResponse> executeWithResilienceAsync(SolrClient client, String collection, SolrQuery query) {
        logger.debug("Executing Solr query asynchronously with resilience - Collection: {}, Query: {}, Timeout: {}ms", new Object[]{collection, query.getQuery(), query.getTimeAllowed()});
        return CompletableFuture.supplyAsync(() -> {
            try {
                return this.executeWithResilience(client, collection, query);
            }
            catch (IOException | SolrServerException e) {
                throw new QueryExecutionException(e);
            }
        }).whenComplete((result, error) -> {
            if (error != null) {
                logger.error("Async query failed after all retry attempts", error);
            } else {
                logger.debug("Async query executed successfully");
            }
        });
    }
}

