/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.connector.plugins.solr.inputs;

import com.lucidworks.connector.plugins.solr.inputs.SolrInput;
import lombok.Generated;
import lombok.NonNull;
import org.apache.solr.client.solrj.SolrQuery;

public final class SolrQueryInput
implements SolrInput {
    @NonNull
    private final String inputId;
    @NonNull
    private final SolrQuery query;
    @NonNull
    private final String collection;
    @NonNull
    private final String parentId;
    private final int batchSize;
    private final boolean isFirstQuery;
    private final boolean useCursorMark;
    private final int maxDocuments;
    private final int documentsProcessed;
    private final String cursorMark;
    private final int offset;

    public static SolrQueryInputBuilder builder(SolrQuery query, String collection) {
        return new SolrQueryInputBuilder().query(query).collection(collection.trim()).parentId("root");
    }

    public static SolrQueryInputBuilder builder(String queryString, String collection) {
        if (queryString == null || queryString.trim().isEmpty()) {
            throw new IllegalArgumentException("Query string cannot be null or empty");
        }
        SolrQuery solrQuery = new SolrQuery(queryString.trim());
        return SolrQueryInput.builder(solrQuery, collection);
    }

    @Generated
    SolrQueryInput(@NonNull String inputId, @NonNull SolrQuery query, @NonNull String collection, @NonNull String parentId, int batchSize, boolean isFirstQuery, boolean useCursorMark, int maxDocuments, int documentsProcessed, String cursorMark, int offset) {
        if (inputId == null) {
            throw new NullPointerException("inputId is marked non-null but is null");
        }
        if (query == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        if (collection == null) {
            throw new NullPointerException("collection is marked non-null but is null");
        }
        if (parentId == null) {
            throw new NullPointerException("parentId is marked non-null but is null");
        }
        this.inputId = inputId;
        this.query = query;
        this.collection = collection;
        this.parentId = parentId;
        this.batchSize = batchSize;
        this.isFirstQuery = isFirstQuery;
        this.useCursorMark = useCursorMark;
        this.maxDocuments = maxDocuments;
        this.documentsProcessed = documentsProcessed;
        this.cursorMark = cursorMark;
        this.offset = offset;
    }

    @NonNull
    @Generated
    public String inputId() {
        return this.inputId;
    }

    @NonNull
    @Generated
    public SolrQuery query() {
        return this.query;
    }

    @NonNull
    @Generated
    public String collection() {
        return this.collection;
    }

    @Override
    @NonNull
    @Generated
    public String parentId() {
        return this.parentId;
    }

    @Generated
    public int batchSize() {
        return this.batchSize;
    }

    @Generated
    public boolean isFirstQuery() {
        return this.isFirstQuery;
    }

    @Generated
    public boolean useCursorMark() {
        return this.useCursorMark;
    }

    @Generated
    public int maxDocuments() {
        return this.maxDocuments;
    }

    @Generated
    public int documentsProcessed() {
        return this.documentsProcessed;
    }

    @Generated
    public String cursorMark() {
        return this.cursorMark;
    }

    @Generated
    public int offset() {
        return this.offset;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SolrQueryInput)) {
            return false;
        }
        SolrQueryInput other = (SolrQueryInput)o;
        if (this.batchSize() != other.batchSize()) {
            return false;
        }
        if (this.isFirstQuery() != other.isFirstQuery()) {
            return false;
        }
        if (this.useCursorMark() != other.useCursorMark()) {
            return false;
        }
        if (this.maxDocuments() != other.maxDocuments()) {
            return false;
        }
        if (this.documentsProcessed() != other.documentsProcessed()) {
            return false;
        }
        if (this.offset() != other.offset()) {
            return false;
        }
        String this$inputId = this.inputId();
        String other$inputId = other.inputId();
        if (this$inputId == null ? other$inputId != null : !this$inputId.equals(other$inputId)) {
            return false;
        }
        SolrQuery this$query = this.query();
        SolrQuery other$query = other.query();
        if (this$query == null ? other$query != null : !this$query.equals(other$query)) {
            return false;
        }
        String this$collection = this.collection();
        String other$collection = other.collection();
        if (this$collection == null ? other$collection != null : !this$collection.equals(other$collection)) {
            return false;
        }
        String this$parentId = this.parentId();
        String other$parentId = other.parentId();
        if (this$parentId == null ? other$parentId != null : !this$parentId.equals(other$parentId)) {
            return false;
        }
        String this$cursorMark = this.cursorMark();
        String other$cursorMark = other.cursorMark();
        return !(this$cursorMark == null ? other$cursorMark != null : !this$cursorMark.equals(other$cursorMark));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.batchSize();
        result = result * 59 + (this.isFirstQuery() ? 79 : 97);
        result = result * 59 + (this.useCursorMark() ? 79 : 97);
        result = result * 59 + this.maxDocuments();
        result = result * 59 + this.documentsProcessed();
        result = result * 59 + this.offset();
        String $inputId = this.inputId();
        result = result * 59 + ($inputId == null ? 43 : $inputId.hashCode());
        SolrQuery $query = this.query();
        result = result * 59 + ($query == null ? 43 : $query.hashCode());
        String $collection = this.collection();
        result = result * 59 + ($collection == null ? 43 : $collection.hashCode());
        String $parentId = this.parentId();
        result = result * 59 + ($parentId == null ? 43 : $parentId.hashCode());
        String $cursorMark = this.cursorMark();
        result = result * 59 + ($cursorMark == null ? 43 : $cursorMark.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SolrQueryInput(inputId=" + this.inputId() + ", query=" + this.query() + ", collection=" + this.collection() + ", parentId=" + this.parentId() + ", batchSize=" + this.batchSize() + ", isFirstQuery=" + this.isFirstQuery() + ", useCursorMark=" + this.useCursorMark() + ", maxDocuments=" + this.maxDocuments() + ", documentsProcessed=" + this.documentsProcessed() + ", cursorMark=" + this.cursorMark() + ", offset=" + this.offset() + ")";
    }

    public static class SolrQueryInputBuilder {
        @Generated
        private String inputId;
        @Generated
        private SolrQuery query;
        @Generated
        private String collection;
        @Generated
        private String parentId;
        @Generated
        private int batchSize;
        @Generated
        private boolean isFirstQuery;
        @Generated
        private boolean useCursorMark;
        @Generated
        private int maxDocuments;
        @Generated
        private int documentsProcessed;
        @Generated
        private String cursorMark;
        @Generated
        private int offset;

        public SolrQueryInput build() {
            this.validateBuilderState();
            if (this.inputId == null) {
                long timestamp = System.currentTimeMillis();
                String queryType = this.useCursorMark ? "cursor" : "offset";
                this.inputId = String.format("solr-query-%s-%s-%d", this.collection, queryType, timestamp);
            }
            return new SolrQueryInput(this.inputId, this.query, this.collection, this.parentId, this.batchSize, this.isFirstQuery, this.useCursorMark, this.maxDocuments, this.documentsProcessed, this.cursorMark, this.offset);
        }

        private void validateBuilderState() {
            if (this.documentsProcessed < 0) {
                throw new IllegalArgumentException("Documents processed cannot be negative, got: " + this.documentsProcessed);
            }
            if (this.offset < 0) {
                throw new IllegalArgumentException("Offset cannot be negative, got: " + this.offset);
            }
            if (this.maxDocuments > 0 && this.documentsProcessed >= this.maxDocuments) {
                throw new IllegalArgumentException(String.format("Documents already processed (%d) exceeds or equals max documents limit (%d)", this.documentsProcessed, this.maxDocuments));
            }
        }

        @Generated
        SolrQueryInputBuilder() {
        }

        @Generated
        public SolrQueryInputBuilder inputId(@NonNull String inputId) {
            if (inputId == null) {
                throw new NullPointerException("inputId is marked non-null but is null");
            }
            this.inputId = inputId;
            return this;
        }

        @Generated
        public SolrQueryInputBuilder query(@NonNull SolrQuery query) {
            if (query == null) {
                throw new NullPointerException("query is marked non-null but is null");
            }
            this.query = query;
            return this;
        }

        @Generated
        public SolrQueryInputBuilder collection(@NonNull String collection) {
            if (collection == null) {
                throw new NullPointerException("collection is marked non-null but is null");
            }
            this.collection = collection;
            return this;
        }

        @Generated
        public SolrQueryInputBuilder parentId(@NonNull String parentId) {
            if (parentId == null) {
                throw new NullPointerException("parentId is marked non-null but is null");
            }
            this.parentId = parentId;
            return this;
        }

        @Generated
        public SolrQueryInputBuilder batchSize(int batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        @Generated
        public SolrQueryInputBuilder isFirstQuery(boolean isFirstQuery) {
            this.isFirstQuery = isFirstQuery;
            return this;
        }

        @Generated
        public SolrQueryInputBuilder useCursorMark(boolean useCursorMark) {
            this.useCursorMark = useCursorMark;
            return this;
        }

        @Generated
        public SolrQueryInputBuilder maxDocuments(int maxDocuments) {
            this.maxDocuments = maxDocuments;
            return this;
        }

        @Generated
        public SolrQueryInputBuilder documentsProcessed(int documentsProcessed) {
            this.documentsProcessed = documentsProcessed;
            return this;
        }

        @Generated
        public SolrQueryInputBuilder cursorMark(String cursorMark) {
            this.cursorMark = cursorMark;
            return this;
        }

        @Generated
        public SolrQueryInputBuilder offset(int offset) {
            this.offset = offset;
            return this;
        }

        @Generated
        public String toString() {
            return "SolrQueryInput.SolrQueryInputBuilder(inputId=" + this.inputId + ", query=" + this.query + ", collection=" + this.collection + ", parentId=" + this.parentId + ", batchSize=" + this.batchSize + ", isFirstQuery=" + this.isFirstQuery + ", useCursorMark=" + this.useCursorMark + ", maxDocuments=" + this.maxDocuments + ", documentsProcessed=" + this.documentsProcessed + ", cursorMark=" + this.cursorMark + ", offset=" + this.offset + ")";
        }
    }
}

