/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.connector.plugins.solr.fetcher.processors;

import com.lucidworks.connector.plugins.solr.config.SolrConfig;
import com.lucidworks.connector.plugins.solr.inputs.SolrQueryInput;
import com.lucidworks.connector.plugins.solr.util.SolrQueryBuilder;
import com.lucidworks.connectors.components.processor.Processor;
import com.lucidworks.connectors.components.processor.TypedEmitter;
import com.lucidworks.connectors.components.processors.InitialInput;
import com.lucidworks.fusion.connector.plugin.api.fetcher.result.FetchResult;
import javax.inject.Inject;
import lombok.Generated;
import org.apache.solr.client.solrj.SolrQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitialProcessor
extends Processor<InitialInput> {
    @Generated
    private static final Logger logger = LoggerFactory.getLogger(InitialProcessor.class);
    private final SolrConfig config;
    private final SolrQueryBuilder queryBuilder;

    @Inject
    public InitialProcessor(SolrConfig config, SolrQueryBuilder queryBuilder) {
        this.config = config;
        this.queryBuilder = queryBuilder;
    }

    public FetchResult process(TypedEmitter ctx, InitialInput ignored) {
        logger.info("Starting initial Solr Connector processing");
        SolrQuery initialQuery = this.queryBuilder.buildInitialQuery(this.config.properties().query(), this.config.properties().advancedQuery());
        String collection = this.config.properties().connection().collection();
        SolrQueryInput queryInput = SolrQueryInput.builder(initialQuery, collection).cursorMark("*").offset(0).batchSize(this.config.properties().query().batchSize()).isFirstQuery(true).useCursorMark(this.config.properties().advancedQuery().useCursorMark()).maxDocuments(this.config.properties().advancedQuery().maxDocuments()).documentsProcessed(0).build();
        logger.info("Emitting initial query for processing: query={}, batchSize={}, useCursorMark={}", new Object[]{initialQuery.getQuery(), queryInput.batchSize(), queryInput.useCursorMark()});
        ctx.emitCandidate(queryInput::toCandidate);
        return ctx.newResult();
    }
}

