/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.connector.plugins.solr.fetcher.processors;

import com.lucidworks.connector.plugins.solr.client.SolrClientHelper;
import com.lucidworks.connector.plugins.solr.config.SolrConfig;
import com.lucidworks.connector.plugins.solr.inputs.SolrQueryInput;
import com.lucidworks.connector.plugins.solr.resilience.ResilientSolrQueryExecutor;
import com.lucidworks.connectors.components.processor.Processor;
import com.lucidworks.connectors.components.processor.TypedEmitter;
import com.lucidworks.connectors.components.processor.model.GsonModel;
import com.lucidworks.connectors.components.processor.model.TypedDocument;
import com.lucidworks.connectors.components.processor.model.builder.TypedDocumentBuilder;
import com.lucidworks.fusion.connector.plugin.api.fetcher.result.FetchResult;
import java.io.IOException;
import java.util.HashMap;
import javax.inject.Inject;
import lombok.Generated;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.params.SolrParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentProcessor
extends Processor<SolrQueryInput> {
    @Generated
    private static final Logger logger = LoggerFactory.getLogger(DocumentProcessor.class);
    private final SolrConfig config;
    private final SolrClient client;
    private final SolrClientHelper helper;
    private final ResilientSolrQueryExecutor resilientExecutor;

    @Inject
    public DocumentProcessor(SolrConfig config, SolrClient client, SolrClientHelper helper, ResilientSolrQueryExecutor resilientExecutor) {
        this.config = config;
        this.client = client;
        this.helper = helper;
        this.resilientExecutor = resilientExecutor;
    }

    public FetchResult process(TypedEmitter ctx, SolrQueryInput input) {
        logger.info("Processing Solr query: {}", (Object)input.query().getQuery());
        try {
            logger.debug("Executing query with retry protection");
            QueryResponse response = this.executeQueryWithResilience(input);
            this.processDocuments(ctx, input, response);
            this.handlePagination(ctx, input, response, this.client);
        }
        catch (Exception e) {
            logger.error("Query failed after all retry attempts", (Throwable)e);
            ctx.emitError((GsonModel.TypedInput)input, "Failed to process Solr query after retries: " + e.getMessage());
        }
        return ctx.newResult();
    }

    private QueryResponse executeQueryWithResilience(SolrQueryInput input) throws SolrServerException, IOException {
        SolrQuery query = input.query();
        int timeoutMs = this.config.properties().advancedQuery().queryTimeoutMs();
        query.setTimeAllowed(Integer.valueOf(timeoutMs));
        if ("SOLRCLOUD".equals(this.config.properties().connection().connectionType())) {
            query.set("shards.preference", new String[]{"replica.type:PULL"});
        }
        return this.resilientExecutor.executeWithResilience(this.client, this.config.properties().connection().collection(), query);
    }

    private QueryResponse executeQuery(SolrClient client, SolrQueryInput input) throws SolrServerException, IOException {
        SolrQuery query = input.query();
        int timeoutMs = this.config.properties().advancedQuery().queryTimeoutMs();
        query.setTimeAllowed(Integer.valueOf(timeoutMs));
        if ("SOLRCLOUD".equals(this.config.properties().connection().connectionType())) {
            query.set("shards.preference", new String[]{"replica.type:PULL"});
        }
        return client.query(this.config.properties().connection().collection(), (SolrParams)query);
    }

    private void processDocuments(TypedEmitter ctx, SolrQueryInput input, QueryResponse response) {
        SolrDocumentList documents = response.getResults();
        logger.info("Retrieved {} documents from Solr", (Object)documents.size());
        for (SolrDocument document : documents) {
            ctx.emitDocument(() -> this.createTypedDocument(document, input));
        }
    }

    private TypedDocument createTypedDocument(SolrDocument document, SolrQueryInput input) {
        Object id = document.getFieldValue("id");
        return TypedDocumentBuilder.builder().id(id.toString()).parentId(input.inputId()).fields(mapBuilder -> {
            HashMap cleanFields = new HashMap();
            document.forEach((fieldName, fieldValue) -> {
                if ("_version_".equals(fieldName)) {
                    cleanFields.put("external_version_s", fieldValue.toString());
                    return;
                }
                cleanFields.put(fieldName, fieldValue);
            });
            mapBuilder.merge(cleanFields);
        }).metadata(mapBuilder -> {
            mapBuilder.setString("source_collection", input.collection());
            mapBuilder.setString("query_cursor", input.cursorMark());
            mapBuilder.setInteger("batch_size", Integer.valueOf(input.batchSize()));
        }).build();
    }

    private void handlePagination(TypedEmitter ctx, SolrQueryInput input, QueryResponse response, SolrClient client) {
        boolean hasMoreResults;
        SolrDocumentList results = response.getResults();
        long totalFound = results.getNumFound();
        int documentsReturned = results.size();
        int newDocumentsProcessed = input.documentsProcessed() + documentsReturned;
        if (input.maxDocuments() > 0 && newDocumentsProcessed >= input.maxDocuments()) {
            logger.info("Reached maximum document limit: {}", (Object)input.maxDocuments());
            return;
        }
        boolean bl = hasMoreResults = (long)newDocumentsProcessed < totalFound;
        if (hasMoreResults) {
            logger.info("More results available ({}/{} processed)", (Object)newDocumentsProcessed, (Object)totalFound);
            if (input.useCursorMark()) {
                if (response.getNextCursorMark() != null) {
                    this.emitCursorMarkQuery(ctx, input, response, newDocumentsProcessed);
                } else {
                    logger.error("Expected cursor mark in response but received null - possible Solr configuration issue");
                    ctx.emitError((GsonModel.TypedInput)input, "Cursor mark pagination failed: response missing nextCursorMark");
                }
            } else {
                this.emitOffsetQuery(ctx, input, newDocumentsProcessed);
            }
        } else {
            logger.info("No more results available, pagination complete");
        }
    }

    private void emitCursorMarkQuery(TypedEmitter ctx, SolrQueryInput input, QueryResponse response, int newDocumentsProcessed) {
        String nextCursorMark = response.getNextCursorMark();
        if (nextCursorMark.equals(input.cursorMark())) {
            logger.warn("Cursor mark didn't advance, stopping pagination to prevent infinite loop");
            return;
        }
        logger.info("Using cursor mark pagination: {}", (Object)nextCursorMark);
        SolrQuery nextQuery = input.query().getCopy();
        nextQuery.set("cursorMark", new String[]{nextCursorMark});
        nextQuery.remove("start");
        SolrQueryInput nextInput = SolrQueryInput.builder(nextQuery, input.collection()).batchSize(input.batchSize()).isFirstQuery(false).useCursorMark(true).maxDocuments(input.maxDocuments()).documentsProcessed(newDocumentsProcessed).cursorMark(nextCursorMark).offset(input.offset()).build();
        ctx.emitCandidate(nextInput::toCandidate);
    }

    private void emitOffsetQuery(TypedEmitter ctx, SolrQueryInput input, int newDocumentsProcessed) {
        int nextOffset = input.offset() + input.batchSize();
        logger.info("Using offset pagination: {}", (Object)nextOffset);
        SolrQuery nextQuery = input.query().getCopy();
        nextQuery.setStart(Integer.valueOf(nextOffset));
        nextQuery.remove("cursorMark");
        SolrQueryInput nextInput = SolrQueryInput.builder(nextQuery, input.collection()).batchSize(input.batchSize()).isFirstQuery(false).useCursorMark(false).maxDocuments(input.maxDocuments()).documentsProcessed(newDocumentsProcessed).offset(nextOffset).build();
        ctx.emitCandidate(nextInput::toCandidate);
    }
}

