/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.connector.plugins.solr.config;

import com.lucidworks.fusion.schema.Model;
import com.lucidworks.fusion.schema.SchemaAnnotations;
import java.util.List;

public interface SolrQueryProperties
extends Model {
    @SchemaAnnotations.Property(title="Query String", description="Solr query string to select documents (use '*:*' for all documents)", order=1, required=true)
    @SchemaAnnotations.StringSchema(defaultValue="*:*", maxLength=2000)
    public String query();

    @SchemaAnnotations.Property(title="Filter Queries", description="List of filter queries to apply (fq parameters). Each filter query further restricts the result set.", order=2, required=false)
    @SchemaAnnotations.ArraySchema(defaultValue="[]")
    @SchemaAnnotations.StringSchema(maxLength=1000)
    public List<String> filterQueries();

    @SchemaAnnotations.Property(title="Sort Specification", description="Sort specification for result ordering. Supports multiple fields separated by commas. Examples: 'price desc', 'score desc, id asc', 'timestamp asc'. When using cursor mark pagination (default), connector automatically appends 'id asc' if not present.", order=3, required=false)
    @SchemaAnnotations.StringSchema(maxLength=200)
    public String sort();

    @SchemaAnnotations.Property(title="Field List To Retrieve", description="Comma-separated list of fields to return. Leave EMPTY for all fields or specify fields like 'id,title,content'.", order=4, required=false)
    @SchemaAnnotations.StringSchema(maxLength=2000)
    public String fieldList();

    @SchemaAnnotations.Property(title="SOLR Request Handler", description="Solr request handler to use for queries", order=5, required=true)
    @SchemaAnnotations.StringSchema(defaultValue="/select", maxLength=100)
    public String requestHandler();

    @SchemaAnnotations.Property(title="Batch Size", description="Number of documents to fetch per request. Higher values improve performance but use more memory. Recommended: 500-1000", required=false, order=6)
    @SchemaAnnotations.NumberSchema(defaultValue=500.0, minimum=1.0, maximum=10000.0)
    public Integer batchSize();

    @SchemaAnnotations.Property(title="Query Parser", description="A specific query parser to use for the request (e.g., 'lucene', 'complexphrase', 'edismax'). When using relevance-based parsers such as edismax include 'score' in the Sort Specification to preserve relevance ranking (e.g., 'score desc').", required=false, order=7)
    @SchemaAnnotations.StringSchema(maxLength=50)
    public String queryParser();
}

