/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.connector.plugins.solr.client;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.request.GenericSolrRequest;
import org.apache.solr.client.solrj.response.SimpleSolrResponse;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrVersionDetector {
    @Generated
    private static final Logger logger = LoggerFactory.getLogger(SolrVersionDetector.class);
    private static final Pattern VERSION_PATTERN = Pattern.compile("^(\\d{1,3})\\.(\\d{1,3})(?:\\.(\\d{1,3}))?");
    private static final SolrVersion CURSOR_MARK_MIN_VERSION = new SolrVersion(4, 7, 0);

    public SolrVersion detectVersion(SolrClient client) {
        try {
            SolrVersion version;
            String solrVersion;
            ModifiableSolrParams params = new ModifiableSolrParams();
            params.set("wt", new String[]{"json"});
            GenericSolrRequest request = new GenericSolrRequest(SolrRequest.METHOD.GET, "/admin/system", (SolrParams)params);
            SimpleSolrResponse response = (SimpleSolrResponse)request.process(client);
            NamedList responseData = response.getResponse();
            NamedList lucene = (NamedList)responseData.get("lucene");
            if (lucene != null && (solrVersion = (String)lucene.get("solr-impl-version")) != null && (version = this.parseVersion(solrVersion)) != null) {
                logger.info("Detected Solr version: {}", (Object)version);
                return version;
            }
            logger.warn("Could not detect Solr version from admin/system response");
            return null;
        }
        catch (Exception e) {
            logger.error("Failed to detect Solr version", (Throwable)e);
            return null;
        }
    }

    public boolean supportsCursorMark(SolrVersion version) {
        if (version == null) {
            logger.warn("Cannot determine cursor mark support - Solr version unknown");
            return false;
        }
        return version.isAtLeast(CURSOR_MARK_MIN_VERSION);
    }

    private SolrVersion parseVersion(String versionString) {
        if (versionString == null || versionString.trim().isEmpty()) {
            return null;
        }
        Matcher matcher = VERSION_PATTERN.matcher(versionString.trim());
        if (matcher.find()) {
            try {
                int major = Integer.parseInt(matcher.group(1));
                int minor = Integer.parseInt(matcher.group(2));
                int patch = matcher.group(3) != null ? Integer.parseInt(matcher.group(3)) : 0;
                return new SolrVersion(major, minor, patch);
            }
            catch (NumberFormatException e) {
                logger.warn("Failed to parse version numbers from: {}", (Object)versionString, (Object)e);
                return null;
            }
        }
        logger.warn("Version string does not match expected pattern: {}", (Object)versionString);
        return null;
    }

    public static class SolrVersion
    implements Comparable<SolrVersion> {
        private final int major;
        private final int minor;
        private final int patch;

        public SolrVersion(int major, int minor, int patch) {
            this.major = major;
            this.minor = minor;
            this.patch = patch;
        }

        public int getMajor() {
            return this.major;
        }

        public int getMinor() {
            return this.minor;
        }

        public int getPatch() {
            return this.patch;
        }

        public boolean isAtLeast(SolrVersion minVersion) {
            return this.compareTo(minVersion) >= 0;
        }

        @Override
        public int compareTo(SolrVersion other) {
            if (this.major != other.major) {
                return Integer.compare(this.major, other.major);
            }
            if (this.minor != other.minor) {
                return Integer.compare(this.minor, other.minor);
            }
            return Integer.compare(this.patch, other.patch);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            SolrVersion that = (SolrVersion)obj;
            return this.major == that.major && this.minor == that.minor && this.patch == that.patch;
        }

        public int hashCode() {
            return this.major * 10000 + this.minor * 100 + this.patch;
        }

        public String toString() {
            return String.format("%d.%d.%d", this.major, this.minor, this.patch);
        }
    }
}

