/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.connector.plugins.solr.client;

import com.google.inject.Provider;
import com.lucidworks.connector.plugins.solr.config.AdvancedSolrConnectionProperties;
import com.lucidworks.connector.plugins.solr.config.SolrConfig;
import com.lucidworks.connector.plugins.solr.config.SolrConnectionProperties;
import com.lucidworks.connector.plugins.solr.exceptions.ClientProviderException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import lombok.Generated;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.impl.Http2SolrClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrClientProvider
implements Provider<SolrClient> {
    @Generated
    private static final Logger logger = LoggerFactory.getLogger(SolrClientProvider.class);
    private final SolrConfig config;

    @Inject
    public SolrClientProvider(SolrConfig config) {
        this.config = config;
    }

    public SolrClient get() {
        try {
            return this.createClient(this.config.properties().connection(), false);
        }
        catch (ClientProviderException e) {
            throw new RuntimeException(e);
        }
    }

    public SolrClient getValidationClient() throws ClientProviderException {
        return this.createClient(this.config.properties().connection(), true);
    }

    private SolrClient createClient(SolrConnectionProperties connectionProps, boolean isValidationClient) throws ClientProviderException {
        try {
            if ("SOLRCLOUD".equals(connectionProps.connectionType())) {
                return this.createSolrCloudClient(connectionProps, isValidationClient);
            }
            return this.createStandaloneSolrClient(connectionProps, isValidationClient);
        }
        catch (Exception e) {
            logger.error("Failed to create Solr client with configuration: {}", (Object)connectionProps, (Object)e);
            throw new ClientProviderException("Failed to create Solr client", e);
        }
    }

    private SolrClient createSolrCloudClient(SolrConnectionProperties props, boolean isValidationClient) {
        logger.info("Creating SolrCloud client for ZK hosts: {}, collection: {}{}", new Object[]{props.zkHosts(), props.collection(), isValidationClient ? " (validation mode with 10s timeout)" : ""});
        List<String> zkHosts = this.parseZkHosts(props.zkHosts());
        CloudSolrClient.Builder builder = new CloudSolrClient.Builder(zkHosts, Optional.empty());
        builder.withDefaultCollection(props.collection());
        AdvancedSolrConnectionProperties advancedProps = this.config.properties().advancedConnection();
        if (isValidationClient) {
            builder.withZkConnectTimeout(10000, TimeUnit.MILLISECONDS);
            builder.withZkClientTimeout(10000, TimeUnit.MILLISECONDS);
        } else {
            if (advancedProps.connectionTimeoutMs() != null) {
                builder.withZkConnectTimeout(advancedProps.connectionTimeoutMs().intValue(), TimeUnit.MILLISECONDS);
            }
            if (advancedProps.socketTimeoutMs() != null) {
                builder.withZkClientTimeout(advancedProps.socketTimeoutMs().intValue(), TimeUnit.MILLISECONDS);
            }
        }
        Http2SolrClient.Builder internalBuilder = new Http2SolrClient.Builder();
        if (isValidationClient) {
            internalBuilder.withConnectionTimeout(10000L, TimeUnit.MILLISECONDS);
            internalBuilder.withRequestTimeout(10000L, TimeUnit.MILLISECONDS);
        } else {
            if (advancedProps.connectionTimeoutMs() != null) {
                internalBuilder.withConnectionTimeout((long)advancedProps.connectionTimeoutMs().intValue(), TimeUnit.MILLISECONDS);
            }
            if (advancedProps.socketTimeoutMs() != null) {
                internalBuilder.withRequestTimeout((long)advancedProps.socketTimeoutMs().intValue(), TimeUnit.MILLISECONDS);
            }
            if (advancedProps.maxConnectionsPerHost() != null) {
                internalBuilder.withMaxConnectionsPerHost(advancedProps.maxConnectionsPerHost().intValue());
            }
        }
        builder.withInternalClientBuilder(internalBuilder);
        return builder.build();
    }

    private SolrClient createStandaloneSolrClient(SolrConnectionProperties props, boolean isValidationClient) {
        logger.info("Creating standalone Solr client for URL: {}{}", (Object)props.solrUrl(), (Object)(isValidationClient ? " (validation mode with 10s timeout)" : ""));
        Object baseUrl = props.solrUrl();
        if (!((String)baseUrl).endsWith("/")) {
            baseUrl = (String)baseUrl + "/";
        }
        Http2SolrClient.Builder builder = new Http2SolrClient.Builder((String)baseUrl);
        if (((String)baseUrl).toLowerCase().startsWith("https://")) {
            logger.debug("Configuring Http2SolrClient for HTTPS with ALPN support");
            builder.useHttp1_1(true);
        }
        AdvancedSolrConnectionProperties advancedProps = this.config.properties().advancedConnection();
        if (isValidationClient) {
            builder.withConnectionTimeout(10000L, TimeUnit.MILLISECONDS);
            builder.withRequestTimeout(10000L, TimeUnit.MILLISECONDS);
        } else {
            if (advancedProps.connectionTimeoutMs() != null) {
                builder.withConnectionTimeout((long)advancedProps.connectionTimeoutMs().intValue(), TimeUnit.MILLISECONDS);
            }
            if (advancedProps.socketTimeoutMs() != null) {
                builder.withRequestTimeout((long)advancedProps.socketTimeoutMs().intValue(), TimeUnit.MILLISECONDS);
            }
            if (advancedProps.maxConnectionsPerHost() != null) {
                builder.withMaxConnectionsPerHost(advancedProps.maxConnectionsPerHost().intValue());
            }
        }
        return builder.build();
    }

    private List<String> parseZkHosts(String zkHosts) {
        return Arrays.asList(zkHosts.split(","));
    }
}

