/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.connector.plugins.solr.client;

import com.lucidworks.connector.plugins.solr.client.SolrVersionDetector;
import com.lucidworks.connector.plugins.solr.config.SolrConnectionProperties;
import com.lucidworks.connector.plugins.solr.config.SolrQueryProperties;
import com.lucidworks.connector.plugins.solr.util.SolrQueryBuilder;
import com.lucidworks.connector.plugins.solr.validation.ValidationQueryResult;
import java.io.IOException;
import javax.inject.Inject;
import lombok.Generated;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.params.SolrParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrClientHelper {
    @Generated
    private static final Logger logger = LoggerFactory.getLogger(SolrClientHelper.class);
    private final SolrVersionDetector versionDetector;
    private final SolrQueryBuilder queryBuilder;

    @Inject
    public SolrClientHelper(SolrVersionDetector versionDetector, SolrQueryBuilder queryBuilder) {
        this.versionDetector = versionDetector;
        this.queryBuilder = queryBuilder;
    }

    public boolean testConnection(SolrClient client, SolrConnectionProperties connectionProps) {
        try {
            if (connectionProps.connectionType() == null || "SOLRCLOUD".equals(connectionProps.connectionType())) {
                client.ping();
                logger.debug("SolrCloud connection test successful");
            } else {
                client.ping(connectionProps.collection());
                logger.debug("Standalone Solr connection test successful for collection: {}", (Object)connectionProps.collection());
            }
            return true;
        }
        catch (Exception e) {
            logger.error("Solr connection test failed for {}: {}", (Object)connectionProps.connectionType(), (Object)e.getMessage());
            return false;
        }
    }

    public boolean supportsCursorMark(SolrClient client) {
        SolrVersionDetector.SolrVersion version = this.versionDetector.detectVersion(client);
        return this.versionDetector.supportsCursorMark(version);
    }

    public ValidationQueryResult testQuery(SolrClient client, SolrConnectionProperties connectionProps, SolrQueryProperties queryProps) {
        try {
            SolrQuery query = this.queryBuilder.buildInitialQuery(queryProps);
            query.setRows(Integer.valueOf(1));
            logger.debug("Testing full query configuration: {}", (Object)query);
            QueryResponse response = client.query(connectionProps.collection(), (SolrParams)query);
            if (response.getStatus() == 0) {
                logger.info("Query validation successful. Found {} results", (Object)response.getResults().getNumFound());
                return ValidationQueryResult.success();
            }
            String errorMsg = "Query validation returned non-zero status: " + response.getStatus() + ". Check query syntax, sort fields, or filter queries.";
            logger.error(errorMsg);
            return ValidationQueryResult.failure(errorMsg);
        }
        catch (SolrServerException e) {
            logger.error("Query validation failed with Solr error: {}", (Object)e.getMessage());
            return ValidationQueryResult.failure("Query Validation Failed. Solr error: " + e.getMessage());
        }
        catch (IOException e) {
            logger.error("Query validation failed with IO error: {}", (Object)e.getMessage());
            return ValidationQueryResult.failure("Query Validation Failed. IO error: " + e.getMessage());
        }
    }

    public void closeClient(SolrClient client) {
        if (client != null) {
            try {
                client.close();
                logger.debug("SolrClient closed successfully");
            }
            catch (IOException e) {
                logger.warn("Error closing SolrClient", (Throwable)e);
            }
        }
    }
}

