/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.fusion.connector.checker.checkers.size;

import com.lucidworks.fusion.connector.checker.checkers.Checker;
import com.lucidworks.fusion.connector.checker.config.SizeLimitConfig;
import com.lucidworks.fusion.connector.checker.input.SizedCheckerInput;
import com.lucidworks.fusion.connector.checker.output.CheckerResult;
import com.lucidworks.fusion.connector.checker.output.FailedCheckerResult;
import com.lucidworks.fusion.connector.checker.output.PassedCheckerResult;

public class SizeChecker
implements Checker<SizedCheckerInput> {
    public static final String TOO_LARGE = "too-large";
    public static final String TOO_SMALL = "too-small";
    private final SizeLimitConfig.Properties sizeLimitConfig;

    public SizeChecker(SizeLimitConfig.Properties sizeLimitConfig) {
        this.sizeLimitConfig = sizeLimitConfig;
    }

    @Override
    public CheckerResult apply(SizedCheckerInput input) {
        long length = input.getSize();
        if (length < (long)this.sizeLimitConfig.minSizeBytes().intValue()) {
            return FailedCheckerResult.failedResult(TOO_SMALL);
        }
        if (this.sizeLimitConfig.maxSizeBytes() != -1 && length > (long)this.sizeLimitConfig.maxSizeBytes().intValue()) {
            return FailedCheckerResult.failedResult(TOO_LARGE);
        }
        return new PassedCheckerResult();
    }
}

