/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.fusion.connector.checker.checkers.pattern;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.lucidworks.fusion.connector.checker.checkers.Checker;
import com.lucidworks.fusion.connector.checker.input.NamedCheckerInput;
import com.lucidworks.fusion.connector.checker.output.CheckerResult;
import com.lucidworks.fusion.connector.checker.output.FailedCheckerResult;
import com.lucidworks.fusion.connector.checker.output.PassedCheckerResult;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class AbstractPatternChecker
implements Checker<NamedCheckerInput> {
    protected final Optional<Cache<String, String>> illegalLinksCache;
    protected final Optional<Cache<String, Boolean>> legalLinksCache;

    public AbstractPatternChecker(int cacheSize) {
        this.legalLinksCache = this.createCache(cacheSize);
        this.illegalLinksCache = this.createCache(cacheSize);
    }

    public static ThreadLocal<Set<Matcher>> makeThreadLocalMatchers(Set<String> regexes) {
        return AbstractPatternChecker.makeThreadLocalMatchers(regexes, 0);
    }

    public static ThreadLocal<Set<Matcher>> makeThreadLocalMatchers(Set<String> regexes, int flags) {
        return ThreadLocal.withInitial(() -> {
            LinkedHashSet<Matcher> matchers = new LinkedHashSet<Matcher>(regexes.size());
            for (String regex : regexes) {
                matchers.add(Pattern.compile(regex, flags).matcher(""));
            }
            return matchers;
        });
    }

    protected static boolean checkInclusion(String id, Set<Matcher> inclusiveMatchers) {
        if (!inclusiveMatchers.isEmpty()) {
            for (Matcher inclusiveMatcher : inclusiveMatchers) {
                if (!inclusiveMatcher.reset(id).matches()) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private <K, V> Optional<Cache<K, V>> createCache(int cacheSize) {
        return cacheSize > 0 ? Optional.of(CacheBuilder.newBuilder().maximumSize((long)cacheSize).build()) : Optional.empty();
    }

    protected abstract CheckerResult specificCheck(NamedCheckerInput var1);

    @Override
    public CheckerResult apply(NamedCheckerInput namedCheckerInput) {
        String name = namedCheckerInput.getName();
        if (null == name) {
            return FailedCheckerResult.failedResult("invalid-item");
        }
        if (this.illegalLinksCache.isPresent() && null != this.illegalLinksCache.get().getIfPresent((Object)name)) {
            return FailedCheckerResult.failedResult((String)this.illegalLinksCache.get().getIfPresent((Object)name));
        }
        if (this.legalLinksCache.isPresent() && null != this.legalLinksCache.get().getIfPresent((Object)name) && ((Boolean)this.legalLinksCache.get().getIfPresent((Object)name)).booleanValue()) {
            return new PassedCheckerResult();
        }
        return this.specificCheck(namedCheckerInput);
    }
}

