/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.connectors.components.injector;

import com.lucidworks.connectors.components.config.ItemRetryConfig;
import com.lucidworks.connectors.components.processor.EmitterConfig;
import com.lucidworks.fusion.connector.plugin.api.config.ConnectorConfig;
import javax.inject.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmitterConfigProvider
implements Provider<EmitterConfig> {
    private static final Logger logger = LoggerFactory.getLogger(EmitterConfigProvider.class);
    private final EmitterConfig emitterConfig;

    public EmitterConfigProvider(ConnectorConfig<?> config) {
        if (config != null && config.properties() instanceof ItemRetryConfig) {
            ItemRetryConfig.Properties properties = ((ItemRetryConfig)config.properties()).itemRetryProperties();
            this.emitterConfig = EmitterConfig.builder().maxRetries(properties.maxRetries()).retryDelayInSeconds(properties.retryDelayInSeconds().intValue()).retryPolicyEnabled(true).build();
            logger.debug("Items will be retried using config={}", (Object)this.emitterConfig);
        } else {
            this.emitterConfig = EmitterConfig.builder().retryPolicyEnabled(false).build();
            logger.warn("ItemRetry properties not found, items will not be retried");
        }
    }

    public EmitterConfig get() {
        return this.emitterConfig;
    }
}

