/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.connectors.components;

import com.github.zafarkhaja.semver.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SDKVersionChecker {
    private static final Logger logger = LoggerFactory.getLogger(SDKVersionChecker.class);

    private SDKVersionChecker() {
    }

    public static void validateSDKVersion(String minVersionAllowed, String version) {
        Version sdkVersion = SDKVersionChecker.versionParser(version);
        Version minVersion = SDKVersionChecker.versionParser(minVersionAllowed);
        if (!SDKVersionChecker.isSDKVersionValid(minVersion, sdkVersion)) {
            String msg = String.format("Box connector incompatible version of the sdk. (minimal version=%s, current version=%s)", minVersion, sdkVersion);
            throw new IllegalArgumentException(msg);
        }
        logger.info("Connectors SDK version={} is valid", (Object)sdkVersion);
    }

    private static boolean isSDKVersionValid(Version minVersion, Version sdkVersion) {
        return sdkVersion.greaterThanOrEqualTo(minVersion);
    }

    private static Version versionParser(String version) {
        try {
            Version real = Version.valueOf((String)version);
            return Version.valueOf((String)real.getNormalVersion());
        }
        catch (Exception ex) {
            String msg = String.format("Can't parse the version=%s", version);
            throw new IllegalArgumentException(msg);
        }
    }
}

