/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.params;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.solr.common.params.SolrParams;

public class ModifiableSolrParams
extends SolrParams {
    private Map<String, String[]> vals;

    public ModifiableSolrParams() {
        this.vals = new LinkedHashMap<String, String[]>();
    }

    public ModifiableSolrParams(Map<String, String[]> v) {
        this.vals = v;
    }

    public ModifiableSolrParams(SolrParams params) {
        this.vals = new LinkedHashMap<String, String[]>();
        if (params != null) {
            this.add(params);
        }
    }

    public static ModifiableSolrParams of(SolrParams params) {
        if (params instanceof ModifiableSolrParams) {
            return (ModifiableSolrParams)params;
        }
        return new ModifiableSolrParams(params);
    }

    public int size() {
        return this.vals == null ? 0 : this.vals.size();
    }

    public Map<String, String[]> getMap() {
        return this.vals;
    }

    public ModifiableSolrParams setNonNull(String name, Object val) {
        if (val != null) {
            this.set(name, String.valueOf(val));
        }
        return this;
    }

    public ModifiableSolrParams set(String name, String ... val) {
        if (val == null || val.length == 1 && val[0] == null) {
            this.vals.remove(name);
        } else {
            this.vals.put(name, val);
        }
        return this;
    }

    public ModifiableSolrParams set(String name, int val) {
        this.set(name, String.valueOf(val));
        return this;
    }

    public ModifiableSolrParams set(String name, boolean val) {
        this.set(name, String.valueOf(val));
        return this;
    }

    public ModifiableSolrParams add(String name, String ... val) {
        String[] old = this.vals.put(name, val);
        if (old != null) {
            if (val == null || val.length < 1) {
                String[] both = new String[old.length + 1];
                System.arraycopy(old, 0, both, 0, old.length);
                both[old.length] = null;
                this.vals.put(name, both);
            } else {
                String[] both = new String[old.length + val.length];
                System.arraycopy(old, 0, both, 0, old.length);
                System.arraycopy(val, 0, both, old.length, val.length);
                this.vals.put(name, both);
            }
        }
        return this;
    }

    public void add(SolrParams params) {
        for (Map.Entry<String, String[]> pair : params) {
            this.set(pair.getKey(), pair.getValue());
        }
    }

    public String[] remove(String name) {
        return this.vals.remove(name);
    }

    public void clear() {
        this.vals.clear();
    }

    public boolean remove(String name, String value) {
        String[] tmp = this.vals.get(name);
        if (tmp == null) {
            return false;
        }
        for (int i = 0; i < tmp.length; ++i) {
            if (!tmp[i].equals(value)) continue;
            String[] tmp2 = new String[tmp.length - 1];
            if (tmp2.length == 0) {
                tmp2 = null;
                this.remove(name);
            } else {
                System.arraycopy(tmp, 0, tmp2, 0, i);
                System.arraycopy(tmp, i + 1, tmp2, i, tmp.length - i - 1);
                this.set(name, tmp2);
            }
            return true;
        }
        return false;
    }

    public void setShardAttributesToParams(int purpose) {
        this.remove("shards");
        this.set("distrib", Boolean.FALSE.toString());
        this.remove("indent");
        this.remove("echoParams");
        this.set("isShard", true);
        this.set("shards.purpose", purpose);
        this.set("omitHeader", false);
    }

    @Override
    public String get(String param) {
        String[] v = this.vals.get(param);
        if (v != null && v.length > 0) {
            return v[0];
        }
        return null;
    }

    @Override
    public Iterator<String> getParameterNamesIterator() {
        return this.vals.keySet().iterator();
    }

    public Set<String> getParameterNames() {
        return this.vals.keySet();
    }

    @Override
    public String[] getParams(String param) {
        return this.vals.get(param);
    }

    @Override
    public Iterator<Map.Entry<String, String[]>> iterator() {
        return this.vals.entrySet().iterator();
    }
}

