/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.request;

import org.apache.solr.client.api.model.IndexType;
import org.apache.solr.client.api.model.SchemaInfoResponse;
import org.apache.solr.client.api.model.SchemaNameResponse;
import org.apache.solr.client.api.model.SchemaSimilarityResponse;
import org.apache.solr.client.api.model.SchemaUniqueKeyResponse;
import org.apache.solr.client.api.model.SchemaVersionResponse;
import org.apache.solr.client.api.model.SchemaZkVersionResponse;
import org.apache.solr.client.solrj.JacksonParsingResponse;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.impl.InputStreamResponseParser;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;

public class SchemaApi {

    public static class GetSchemaZkVersion
    extends SolrRequest<GetSchemaZkVersionResponse> {
        private final IndexType indexType;
        private final String indexName;
        private Integer refreshIfBelowVersion;

        public GetSchemaZkVersion(IndexType indexType, String indexName) {
            super(SolrRequest.METHOD.valueOf("GET"), "/{indexType}/{indexName}/schema/zkversion".replace("{indexType}", indexType.toString()).replace("{indexName}", indexName));
            this.indexType = indexType;
            this.indexName = indexName;
        }

        public void setRefreshIfBelowVersion(Integer refreshIfBelowVersion) {
            this.refreshIfBelowVersion = refreshIfBelowVersion;
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            if (this.refreshIfBelowVersion != null) {
                params.add("refreshIfBelowVersion", this.refreshIfBelowVersion.toString());
            }
            return params;
        }

        @Override
        protected GetSchemaZkVersionResponse createResponse(SolrClient client) {
            return new GetSchemaZkVersionResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class GetSchemaZkVersionResponse
    extends JacksonParsingResponse<SchemaZkVersionResponse> {
        public GetSchemaZkVersionResponse() {
            super(SchemaZkVersionResponse.class);
        }
    }

    public static class GetSchemaVersion
    extends SolrRequest<GetSchemaVersionResponse> {
        private final IndexType indexType;
        private final String indexName;

        public GetSchemaVersion(IndexType indexType, String indexName) {
            super(SolrRequest.METHOD.valueOf("GET"), "/{indexType}/{indexName}/schema/version".replace("{indexType}", indexType.toString()).replace("{indexName}", indexName));
            this.indexType = indexType;
            this.indexName = indexName;
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            return params;
        }

        @Override
        protected GetSchemaVersionResponse createResponse(SolrClient client) {
            return new GetSchemaVersionResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class GetSchemaVersionResponse
    extends JacksonParsingResponse<SchemaVersionResponse> {
        public GetSchemaVersionResponse() {
            super(SchemaVersionResponse.class);
        }
    }

    public static class GetSchemaUniqueKey
    extends SolrRequest<GetSchemaUniqueKeyResponse> {
        private final IndexType indexType;
        private final String indexName;

        public GetSchemaUniqueKey(IndexType indexType, String indexName) {
            super(SolrRequest.METHOD.valueOf("GET"), "/{indexType}/{indexName}/schema/uniquekey".replace("{indexType}", indexType.toString()).replace("{indexName}", indexName));
            this.indexType = indexType;
            this.indexName = indexName;
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            return params;
        }

        @Override
        protected GetSchemaUniqueKeyResponse createResponse(SolrClient client) {
            return new GetSchemaUniqueKeyResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class GetSchemaUniqueKeyResponse
    extends JacksonParsingResponse<SchemaUniqueKeyResponse> {
        public GetSchemaUniqueKeyResponse() {
            super(SchemaUniqueKeyResponse.class);
        }
    }

    public static class GetSchemaSimilarity
    extends SolrRequest<GetSchemaSimilarityResponse> {
        private final IndexType indexType;
        private final String indexName;

        public GetSchemaSimilarity(IndexType indexType, String indexName) {
            super(SolrRequest.METHOD.valueOf("GET"), "/{indexType}/{indexName}/schema/similarity".replace("{indexType}", indexType.toString()).replace("{indexName}", indexName));
            this.indexType = indexType;
            this.indexName = indexName;
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            return params;
        }

        @Override
        protected GetSchemaSimilarityResponse createResponse(SolrClient client) {
            return new GetSchemaSimilarityResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class GetSchemaSimilarityResponse
    extends JacksonParsingResponse<SchemaSimilarityResponse> {
        public GetSchemaSimilarityResponse() {
            super(SchemaSimilarityResponse.class);
        }
    }

    public static class GetSchemaName
    extends SolrRequest<GetSchemaNameResponse> {
        private final IndexType indexType;
        private final String indexName;

        public GetSchemaName(IndexType indexType, String indexName) {
            super(SolrRequest.METHOD.valueOf("GET"), "/{indexType}/{indexName}/schema/name".replace("{indexType}", indexType.toString()).replace("{indexName}", indexName));
            this.indexType = indexType;
            this.indexName = indexName;
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            return params;
        }

        @Override
        protected GetSchemaNameResponse createResponse(SolrClient client) {
            return new GetSchemaNameResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class GetSchemaNameResponse
    extends JacksonParsingResponse<SchemaNameResponse> {
        public GetSchemaNameResponse() {
            super(SchemaNameResponse.class);
        }
    }

    public static class GetSchemaInfo
    extends SolrRequest<GetSchemaInfoResponse> {
        private final IndexType indexType;
        private final String indexName;

        public GetSchemaInfo(IndexType indexType, String indexName) {
            super(SolrRequest.METHOD.valueOf("GET"), "/{indexType}/{indexName}/schema".replace("{indexType}", indexType.toString()).replace("{indexName}", indexName));
            this.indexType = indexType;
            this.indexName = indexName;
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            return params;
        }

        @Override
        protected GetSchemaInfoResponse createResponse(SolrClient client) {
            return new GetSchemaInfoResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class GetSchemaInfoResponse
    extends JacksonParsingResponse<SchemaInfoResponse> {
        public GetSchemaInfoResponse() {
            super(SchemaInfoResponse.class);
        }
    }
}

