/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.utils.request;

import com.kaltura.client.Client;
import com.kaltura.client.Configuration;
import com.kaltura.client.FileHolder;
import com.kaltura.client.Files;
import com.kaltura.client.Params;
import com.kaltura.client.types.APIException;
import com.kaltura.client.utils.EncryptionUtils;
import com.kaltura.client.utils.GsonParser;
import com.kaltura.client.utils.request.ConnectionConfiguration;
import com.kaltura.client.utils.request.RequestBuilderData;
import com.kaltura.client.utils.request.RequestElement;
import com.kaltura.client.utils.response.OnCompletion;
import com.kaltura.client.utils.response.base.Response;
import com.kaltura.client.utils.response.base.ResponseElement;
import java.util.HashMap;
import java.util.Map;

public abstract class BaseRequestBuilder<ReturnedType, SelfType>
extends RequestBuilderData<SelfType>
implements RequestElement<ReturnedType> {
    protected Class<ReturnedType> type;
    protected String url;
    protected Files files = null;
    protected HashMap<String, String> headers;
    protected ConnectionConfiguration connectionConfig;
    protected OnCompletion<Response<ReturnedType>> onCompletion;

    protected BaseRequestBuilder(Class<ReturnedType> type) {
        this.type = type;
    }

    protected abstract String getUrlTail();

    @Override
    public abstract String getTag();

    public Class<?> getType() {
        return this.type;
    }

    @Override
    public String getMethod() {
        return "POST";
    }

    @Override
    public String getBody() {
        return this.params.toString();
    }

    protected Params getParams() {
        return this.params;
    }

    public void setParams(Map<String, Object> objParams) {
        this.params.putAll(objParams);
    }

    public BaseRequestBuilder<ReturnedType, SelfType> setFile(String key, FileHolder value) {
        if (this.files != null) {
            this.files.add(key, value);
        }
        return this;
    }

    @Override
    public HashMap<String, String> getHeaders() {
        return this.headers;
    }

    @Override
    public Files getFiles() {
        return this.files;
    }

    public void setHeaders(HashMap<String, String> headers) {
        this.headers = headers;
    }

    public void setHeaders(String ... nameValueHeaders) {
        for (int i = 0; i < nameValueHeaders.length - 1; i += 2) {
            this.headers.put(nameValueHeaders[i], nameValueHeaders[i + 1]);
        }
    }

    @Override
    public String getContentType() {
        return this.headers != null ? this.headers.get("Content-Type") : "application/json";
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public ConnectionConfiguration config() {
        return this.connectionConfig;
    }

    protected Params prepareParams(Client configurations, boolean addSignature) {
        if (this.params == null) {
            this.params = new Params();
        }
        this.params.add("ignoreNull", true);
        if (configurations != null) {
            this.params.putAll(configurations.getClientConfiguration());
            this.params.putAll(configurations.getRequestConfiguration());
        }
        if (addSignature) {
            this.params.add("kalsig", EncryptionUtils.encryptMD5(this.params.toString()));
        }
        return this.params;
    }

    protected void prepareUrl(String endPoint) {
        if (this.url == null) {
            StringBuilder urlBuilder = new StringBuilder(endPoint.replaceAll("/$", "")).append("/").append("api_v3/");
            urlBuilder.append(this.getUrlTail());
            this.url = urlBuilder.toString();
        }
    }

    public RequestElement<ReturnedType> build(Client client) {
        return this.build(client, false);
    }

    @Override
    public final Response<ReturnedType> parseResponse(ResponseElement response) {
        Object result = null;
        APIException error = null;
        if (!response.isSuccess()) {
            error = this.generateErrorResponse(response);
        } else {
            try {
                result = this.parse(response.getResponse());
            }
            catch (APIException e) {
                error = e;
            }
        }
        return new Response<Object>(result, error);
    }

    @Override
    public void onComplete(Response<ReturnedType> response) {
        if (this.onCompletion != null) {
            this.onCompletion.onComplete(response);
        }
    }

    protected Object parse(String response) throws APIException {
        if (response.length() == 0 || response.toLowerCase().equals("null")) {
            return null;
        }
        return GsonParser.parseObject(response, this.type);
    }

    protected APIException generateErrorResponse(ResponseElement response) {
        if (response.getError() != null) {
            APIException exception = new APIException(response.getError().getMessage());
            exception.setCode(String.valueOf(response.getError().getCode()));
            return exception;
        }
        APIException exception = new APIException(response.getResponse());
        exception.setCode(String.valueOf(-1));
        return exception;
    }

    public RequestElement<ReturnedType> build(Client client, boolean addSignature) {
        this.connectionConfig = client != null ? client.getConnectionConfiguration() : Configuration.getDefaults();
        this.prepareParams(client, addSignature);
        this.prepareHeaders(this.connectionConfig);
        this.prepareUrl(this.connectionConfig.getEndpoint());
        return this;
    }

    protected void prepareHeaders(ConnectionConfiguration config) {
        if (this.headers == null) {
            this.headers = new HashMap();
        }
        this.addDefaultHeaders();
        if (!this.headers.containsKey("Accept-Encoding") && config.getAcceptGzipEncoding()) {
            this.headers.put("Accept-Encoding", "gzip");
        }
    }

    private void addDefaultHeaders() {
        if (!this.headers.containsKey("Accept")) {
            this.headers.put("Accept", "application/json");
        }
        if (!this.headers.containsKey("Accept-Charset")) {
            this.headers.put("Accept-Charset", "utf-8,ISO-8859-1;q=0.7,*;q=0.5");
        }
    }
}

