/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.utils;

import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class EncryptionUtils {
    public static final int BLOCK_SIZE = 16;

    public static byte[] encryptSHA1(String str) throws Exception {
        return EncryptionUtils.encryptSHA1(str.getBytes());
    }

    public static byte[] encryptSHA1(byte[] data) throws Exception {
        try {
            MessageDigest algorithm = MessageDigest.getInstance("SHA1");
            algorithm.reset();
            algorithm.update(data);
            byte[] infoSignature = algorithm.digest();
            return infoSignature;
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            throw new Exception(e);
        }
    }

    public static byte[] encryptAES(String secretKey, byte[] dataBytes) throws Exception {
        byte[] encryptedKey = EncryptionUtils.encryptSHA1(secretKey);
        byte[] keyBytes = new byte[16];
        System.arraycopy(encryptedKey, 0, keyBytes, 0, 16);
        SecretKeySpec key = new SecretKeySpec(keyBytes, "AES");
        byte[] ivBytes = new byte[16];
        IvParameterSpec iv = new IvParameterSpec(ivBytes);
        int textSize = (dataBytes.length + 16 - 1) / 16 * 16;
        byte[] textAsBytes = new byte[textSize];
        Arrays.fill(textAsBytes, (byte)0);
        System.arraycopy(dataBytes, 0, textAsBytes, 0, dataBytes.length);
        Cipher cipher = Cipher.getInstance("AES/CBC/NOPADDING");
        cipher.init(1, (Key)key, iv);
        return cipher.doFinal(textAsBytes);
    }

    public static String encryptMD5t(String str) {
        if (str == null || str.length() == 0) {
            return "";
        }
        MessageDigest digester = null;
        try {
            digester = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return "";
        }
        digester.update(str.getBytes());
        byte[] hash = digester.digest();
        StringBuffer hexString = new StringBuffer();
        for (int i = 0; i < hash.length; ++i) {
            if ((0xFF & hash[i]) < 16) {
                hexString.append("0" + Integer.toHexString(0xFF & hash[i]));
                continue;
            }
            hexString.append(Integer.toHexString(0xFF & hash[i]));
        }
        return hexString.toString();
    }

    public static String encryptMD5(String str) {
        if (str == null || str.length() == 0) {
            return "";
        }
        MessageDigest digester = null;
        try {
            digester = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return "";
        }
        digester.update(str.getBytes());
        byte[] digest = digester.digest();
        StringBuilder sb = new StringBuilder();
        for (byte b : digest) {
            sb.append(String.format("%02x", b & 0xFF));
        }
        return sb.toString();
    }
}

