/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.types;

import com.google.gson.JsonObject;
import com.kaltura.client.Params;
import com.kaltura.client.enums.VirusFoundAction;
import com.kaltura.client.enums.VirusScanJobResult;
import com.kaltura.client.types.APIException;
import com.kaltura.client.types.FileContainer;
import com.kaltura.client.types.JobData;
import com.kaltura.client.utils.GsonParser;
import com.kaltura.client.utils.request.MultiRequestBuilder;

@MultiRequestBuilder.Tokenizer(value=Tokenizer.class)
public class VirusScanJobData
extends JobData {
    private FileContainer fileContainer;
    private String flavorAssetId;
    private VirusScanJobResult scanResult;
    private VirusFoundAction virusFoundAction;

    public FileContainer getFileContainer() {
        return this.fileContainer;
    }

    public void setFileContainer(FileContainer fileContainer) {
        this.fileContainer = fileContainer;
    }

    public String getFlavorAssetId() {
        return this.flavorAssetId;
    }

    public void setFlavorAssetId(String flavorAssetId) {
        this.flavorAssetId = flavorAssetId;
    }

    public void flavorAssetId(String multirequestToken) {
        this.setToken("flavorAssetId", multirequestToken);
    }

    public VirusScanJobResult getScanResult() {
        return this.scanResult;
    }

    public void setScanResult(VirusScanJobResult scanResult) {
        this.scanResult = scanResult;
    }

    public void scanResult(String multirequestToken) {
        this.setToken("scanResult", multirequestToken);
    }

    public VirusFoundAction getVirusFoundAction() {
        return this.virusFoundAction;
    }

    public void setVirusFoundAction(VirusFoundAction virusFoundAction) {
        this.virusFoundAction = virusFoundAction;
    }

    public void virusFoundAction(String multirequestToken) {
        this.setToken("virusFoundAction", multirequestToken);
    }

    public VirusScanJobData() {
    }

    public VirusScanJobData(JsonObject jsonObject) throws APIException {
        super(jsonObject);
        if (jsonObject == null) {
            return;
        }
        this.fileContainer = GsonParser.parseObject(jsonObject.getAsJsonObject("fileContainer"), FileContainer.class);
        this.flavorAssetId = GsonParser.parseString(jsonObject.get("flavorAssetId"));
        this.scanResult = VirusScanJobResult.get(GsonParser.parseInt(jsonObject.get("scanResult")));
        this.virusFoundAction = VirusFoundAction.get(GsonParser.parseInt(jsonObject.get("virusFoundAction")));
    }

    @Override
    public Params toParams() {
        Params kparams = super.toParams();
        kparams.add("objectType", "KalturaVirusScanJobData");
        kparams.add("fileContainer", this.fileContainer);
        kparams.add("flavorAssetId", this.flavorAssetId);
        kparams.add("scanResult", this.scanResult);
        kparams.add("virusFoundAction", this.virusFoundAction);
        return kparams;
    }

    public static interface Tokenizer
    extends JobData.Tokenizer {
        public FileContainer.Tokenizer fileContainer();

        public String flavorAssetId();

        public String scanResult();

        public String virusFoundAction();
    }
}

