/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.types;

import com.google.gson.JsonObject;
import com.kaltura.client.Params;
import com.kaltura.client.types.APIException;
import com.kaltura.client.types.UrlTokenizer;
import com.kaltura.client.utils.GsonParser;
import com.kaltura.client.utils.request.MultiRequestBuilder;

@MultiRequestBuilder.Tokenizer(value=Tokenizer.class)
public class UrlTokenizerCloudFront
extends UrlTokenizer {
    private String keyPairId;
    private String rootDir;

    public String getKeyPairId() {
        return this.keyPairId;
    }

    public void setKeyPairId(String keyPairId) {
        this.keyPairId = keyPairId;
    }

    public void keyPairId(String multirequestToken) {
        this.setToken("keyPairId", multirequestToken);
    }

    public String getRootDir() {
        return this.rootDir;
    }

    public void setRootDir(String rootDir) {
        this.rootDir = rootDir;
    }

    public void rootDir(String multirequestToken) {
        this.setToken("rootDir", multirequestToken);
    }

    public UrlTokenizerCloudFront() {
    }

    public UrlTokenizerCloudFront(JsonObject jsonObject) throws APIException {
        super(jsonObject);
        if (jsonObject == null) {
            return;
        }
        this.keyPairId = GsonParser.parseString(jsonObject.get("keyPairId"));
        this.rootDir = GsonParser.parseString(jsonObject.get("rootDir"));
    }

    @Override
    public Params toParams() {
        Params kparams = super.toParams();
        kparams.add("objectType", "KalturaUrlTokenizerCloudFront");
        kparams.add("keyPairId", this.keyPairId);
        kparams.add("rootDir", this.rootDir);
        return kparams;
    }

    public static interface Tokenizer
    extends UrlTokenizer.Tokenizer {
        public String keyPairId();

        public String rootDir();
    }
}

