/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.types;

import com.google.gson.JsonObject;
import com.kaltura.client.Params;
import com.kaltura.client.types.APIException;
import com.kaltura.client.types.ContentResource;
import com.kaltura.client.types.StringHolder;
import com.kaltura.client.utils.GsonParser;
import com.kaltura.client.utils.request.MultiRequestBuilder;
import com.kaltura.client.utils.request.RequestBuilder;
import java.util.List;

@MultiRequestBuilder.Tokenizer(value=Tokenizer.class)
public class UrlResource
extends ContentResource {
    private String url;
    private Boolean forceAsyncDownload;
    private List<StringHolder> urlHeaders;

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void url(String multirequestToken) {
        this.setToken("url", multirequestToken);
    }

    public Boolean getForceAsyncDownload() {
        return this.forceAsyncDownload;
    }

    public void setForceAsyncDownload(Boolean forceAsyncDownload) {
        this.forceAsyncDownload = forceAsyncDownload;
    }

    public void forceAsyncDownload(String multirequestToken) {
        this.setToken("forceAsyncDownload", multirequestToken);
    }

    public List<StringHolder> getUrlHeaders() {
        return this.urlHeaders;
    }

    public void setUrlHeaders(List<StringHolder> urlHeaders) {
        this.urlHeaders = urlHeaders;
    }

    public UrlResource() {
    }

    public UrlResource(JsonObject jsonObject) throws APIException {
        super(jsonObject);
        if (jsonObject == null) {
            return;
        }
        this.url = GsonParser.parseString(jsonObject.get("url"));
        this.forceAsyncDownload = GsonParser.parseBoolean(jsonObject.get("forceAsyncDownload"));
        this.urlHeaders = GsonParser.parseArray(jsonObject.getAsJsonArray("urlHeaders"), StringHolder.class);
    }

    @Override
    public Params toParams() {
        Params kparams = super.toParams();
        kparams.add("objectType", "KalturaUrlResource");
        kparams.add("url", this.url);
        kparams.add("forceAsyncDownload", this.forceAsyncDownload);
        kparams.add("urlHeaders", this.urlHeaders);
        return kparams;
    }

    public static interface Tokenizer
    extends ContentResource.Tokenizer {
        public String url();

        public String forceAsyncDownload();

        public RequestBuilder.ListTokenizer<StringHolder.Tokenizer> urlHeaders();
    }
}

