/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.types;

import com.google.gson.JsonObject;
import com.kaltura.client.Params;
import com.kaltura.client.types.APIException;
import com.kaltura.client.types.FileContainer;
import com.kaltura.client.types.JobData;
import com.kaltura.client.utils.GsonParser;
import com.kaltura.client.utils.request.MultiRequestBuilder;

@MultiRequestBuilder.Tokenizer(value=Tokenizer.class)
public class TransformMetadataJobData
extends JobData {
    private FileContainer srcXsl;
    private Integer srcVersion;
    private Integer destVersion;
    private FileContainer destXsd;
    private Integer metadataProfileId;

    public FileContainer getSrcXsl() {
        return this.srcXsl;
    }

    public void setSrcXsl(FileContainer srcXsl) {
        this.srcXsl = srcXsl;
    }

    public Integer getSrcVersion() {
        return this.srcVersion;
    }

    public void setSrcVersion(Integer srcVersion) {
        this.srcVersion = srcVersion;
    }

    public void srcVersion(String multirequestToken) {
        this.setToken("srcVersion", multirequestToken);
    }

    public Integer getDestVersion() {
        return this.destVersion;
    }

    public void setDestVersion(Integer destVersion) {
        this.destVersion = destVersion;
    }

    public void destVersion(String multirequestToken) {
        this.setToken("destVersion", multirequestToken);
    }

    public FileContainer getDestXsd() {
        return this.destXsd;
    }

    public void setDestXsd(FileContainer destXsd) {
        this.destXsd = destXsd;
    }

    public Integer getMetadataProfileId() {
        return this.metadataProfileId;
    }

    public void setMetadataProfileId(Integer metadataProfileId) {
        this.metadataProfileId = metadataProfileId;
    }

    public void metadataProfileId(String multirequestToken) {
        this.setToken("metadataProfileId", multirequestToken);
    }

    public TransformMetadataJobData() {
    }

    public TransformMetadataJobData(JsonObject jsonObject) throws APIException {
        super(jsonObject);
        if (jsonObject == null) {
            return;
        }
        this.srcXsl = GsonParser.parseObject(jsonObject.getAsJsonObject("srcXsl"), FileContainer.class);
        this.srcVersion = GsonParser.parseInt(jsonObject.get("srcVersion"));
        this.destVersion = GsonParser.parseInt(jsonObject.get("destVersion"));
        this.destXsd = GsonParser.parseObject(jsonObject.getAsJsonObject("destXsd"), FileContainer.class);
        this.metadataProfileId = GsonParser.parseInt(jsonObject.get("metadataProfileId"));
    }

    @Override
    public Params toParams() {
        Params kparams = super.toParams();
        kparams.add("objectType", "KalturaTransformMetadataJobData");
        kparams.add("srcXsl", this.srcXsl);
        kparams.add("srcVersion", this.srcVersion);
        kparams.add("destVersion", this.destVersion);
        kparams.add("destXsd", this.destXsd);
        kparams.add("metadataProfileId", this.metadataProfileId);
        return kparams;
    }

    public static interface Tokenizer
    extends JobData.Tokenizer {
        public FileContainer.Tokenizer srcXsl();

        public String srcVersion();

        public String destVersion();

        public FileContainer.Tokenizer destXsd();

        public String metadataProfileId();
    }
}

