/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.types;

import com.google.gson.JsonObject;
import com.kaltura.client.Params;
import com.kaltura.client.enums.Language;
import com.kaltura.client.enums.TranscriptProviderType;
import com.kaltura.client.types.APIException;
import com.kaltura.client.types.AttachmentAsset;
import com.kaltura.client.utils.GsonParser;
import com.kaltura.client.utils.request.MultiRequestBuilder;

@MultiRequestBuilder.Tokenizer(value=Tokenizer.class)
public class TranscriptAsset
extends AttachmentAsset {
    private Double accuracy;
    private Boolean humanVerified;
    private Language language;
    private TranscriptProviderType providerType;

    public Double getAccuracy() {
        return this.accuracy;
    }

    public void setAccuracy(Double accuracy) {
        this.accuracy = accuracy;
    }

    public void accuracy(String multirequestToken) {
        this.setToken("accuracy", multirequestToken);
    }

    public Boolean getHumanVerified() {
        return this.humanVerified;
    }

    public void setHumanVerified(Boolean humanVerified) {
        this.humanVerified = humanVerified;
    }

    public void humanVerified(String multirequestToken) {
        this.setToken("humanVerified", multirequestToken);
    }

    public Language getLanguage() {
        return this.language;
    }

    public void setLanguage(Language language) {
        this.language = language;
    }

    public void language(String multirequestToken) {
        this.setToken("language", multirequestToken);
    }

    public TranscriptProviderType getProviderType() {
        return this.providerType;
    }

    public void setProviderType(TranscriptProviderType providerType) {
        this.providerType = providerType;
    }

    public void providerType(String multirequestToken) {
        this.setToken("providerType", multirequestToken);
    }

    public TranscriptAsset() {
    }

    public TranscriptAsset(JsonObject jsonObject) throws APIException {
        super(jsonObject);
        if (jsonObject == null) {
            return;
        }
        this.accuracy = GsonParser.parseDouble(jsonObject.get("accuracy"));
        this.humanVerified = GsonParser.parseBoolean(jsonObject.get("humanVerified"));
        this.language = Language.get(GsonParser.parseString(jsonObject.get("language")));
        this.providerType = TranscriptProviderType.get(GsonParser.parseString(jsonObject.get("providerType")));
    }

    @Override
    public Params toParams() {
        Params kparams = super.toParams();
        kparams.add("objectType", "KalturaTranscriptAsset");
        kparams.add("accuracy", this.accuracy);
        kparams.add("humanVerified", this.humanVerified);
        kparams.add("language", this.language);
        kparams.add("providerType", this.providerType);
        return kparams;
    }

    public static interface Tokenizer
    extends AttachmentAsset.Tokenizer {
        public String accuracy();

        public String humanVerified();

        public String language();

        public String providerType();
    }
}

