/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.types;

import com.google.gson.JsonObject;
import com.kaltura.client.Params;
import com.kaltura.client.enums.BatchJobType;
import com.kaltura.client.types.APIException;
import com.kaltura.client.types.BatchJob;
import com.kaltura.client.types.ObjectBase;
import com.kaltura.client.types.SchedulerConfig;
import com.kaltura.client.types.SchedulerStatus;
import com.kaltura.client.utils.GsonParser;
import com.kaltura.client.utils.request.MultiRequestBuilder;
import com.kaltura.client.utils.request.RequestBuilder;
import java.util.List;

@MultiRequestBuilder.Tokenizer(value=Tokenizer.class)
public class SchedulerWorker
extends ObjectBase {
    private Integer id;
    private Integer configuredId;
    private Integer schedulerId;
    private Integer schedulerConfiguredId;
    private BatchJobType type;
    private String typeName;
    private String name;
    private List<SchedulerStatus> statuses;
    private List<SchedulerConfig> configs;
    private List<BatchJob> lockedJobs;
    private Integer avgWait;
    private Integer avgWork;
    private Integer lastStatus;
    private String lastStatusStr;

    public Integer getId() {
        return this.id;
    }

    public Integer getConfiguredId() {
        return this.configuredId;
    }

    public void setConfiguredId(Integer configuredId) {
        this.configuredId = configuredId;
    }

    public void configuredId(String multirequestToken) {
        this.setToken("configuredId", multirequestToken);
    }

    public Integer getSchedulerId() {
        return this.schedulerId;
    }

    public void setSchedulerId(Integer schedulerId) {
        this.schedulerId = schedulerId;
    }

    public void schedulerId(String multirequestToken) {
        this.setToken("schedulerId", multirequestToken);
    }

    public Integer getSchedulerConfiguredId() {
        return this.schedulerConfiguredId;
    }

    public void setSchedulerConfiguredId(Integer schedulerConfiguredId) {
        this.schedulerConfiguredId = schedulerConfiguredId;
    }

    public void schedulerConfiguredId(String multirequestToken) {
        this.setToken("schedulerConfiguredId", multirequestToken);
    }

    public BatchJobType getType() {
        return this.type;
    }

    public void setType(BatchJobType type) {
        this.type = type;
    }

    public void type(String multirequestToken) {
        this.setToken("type", multirequestToken);
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public void typeName(String multirequestToken) {
        this.setToken("typeName", multirequestToken);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void name(String multirequestToken) {
        this.setToken("name", multirequestToken);
    }

    public List<SchedulerStatus> getStatuses() {
        return this.statuses;
    }

    public void setStatuses(List<SchedulerStatus> statuses) {
        this.statuses = statuses;
    }

    public List<SchedulerConfig> getConfigs() {
        return this.configs;
    }

    public void setConfigs(List<SchedulerConfig> configs) {
        this.configs = configs;
    }

    public List<BatchJob> getLockedJobs() {
        return this.lockedJobs;
    }

    public void setLockedJobs(List<BatchJob> lockedJobs) {
        this.lockedJobs = lockedJobs;
    }

    public Integer getAvgWait() {
        return this.avgWait;
    }

    public void setAvgWait(Integer avgWait) {
        this.avgWait = avgWait;
    }

    public void avgWait(String multirequestToken) {
        this.setToken("avgWait", multirequestToken);
    }

    public Integer getAvgWork() {
        return this.avgWork;
    }

    public void setAvgWork(Integer avgWork) {
        this.avgWork = avgWork;
    }

    public void avgWork(String multirequestToken) {
        this.setToken("avgWork", multirequestToken);
    }

    public Integer getLastStatus() {
        return this.lastStatus;
    }

    public void setLastStatus(Integer lastStatus) {
        this.lastStatus = lastStatus;
    }

    public void lastStatus(String multirequestToken) {
        this.setToken("lastStatus", multirequestToken);
    }

    public String getLastStatusStr() {
        return this.lastStatusStr;
    }

    public void setLastStatusStr(String lastStatusStr) {
        this.lastStatusStr = lastStatusStr;
    }

    public void lastStatusStr(String multirequestToken) {
        this.setToken("lastStatusStr", multirequestToken);
    }

    public SchedulerWorker() {
    }

    public SchedulerWorker(JsonObject jsonObject) throws APIException {
        super(jsonObject);
        if (jsonObject == null) {
            return;
        }
        this.id = GsonParser.parseInt(jsonObject.get("id"));
        this.configuredId = GsonParser.parseInt(jsonObject.get("configuredId"));
        this.schedulerId = GsonParser.parseInt(jsonObject.get("schedulerId"));
        this.schedulerConfiguredId = GsonParser.parseInt(jsonObject.get("schedulerConfiguredId"));
        this.type = BatchJobType.get(GsonParser.parseString(jsonObject.get("type")));
        this.typeName = GsonParser.parseString(jsonObject.get("typeName"));
        this.name = GsonParser.parseString(jsonObject.get("name"));
        this.statuses = GsonParser.parseArray(jsonObject.getAsJsonArray("statuses"), SchedulerStatus.class);
        this.configs = GsonParser.parseArray(jsonObject.getAsJsonArray("configs"), SchedulerConfig.class);
        this.lockedJobs = GsonParser.parseArray(jsonObject.getAsJsonArray("lockedJobs"), BatchJob.class);
        this.avgWait = GsonParser.parseInt(jsonObject.get("avgWait"));
        this.avgWork = GsonParser.parseInt(jsonObject.get("avgWork"));
        this.lastStatus = GsonParser.parseInt(jsonObject.get("lastStatus"));
        this.lastStatusStr = GsonParser.parseString(jsonObject.get("lastStatusStr"));
    }

    @Override
    public Params toParams() {
        Params kparams = super.toParams();
        kparams.add("objectType", "KalturaSchedulerWorker");
        kparams.add("configuredId", this.configuredId);
        kparams.add("schedulerId", this.schedulerId);
        kparams.add("schedulerConfiguredId", this.schedulerConfiguredId);
        kparams.add("type", this.type);
        kparams.add("typeName", this.typeName);
        kparams.add("name", this.name);
        kparams.add("statuses", this.statuses);
        kparams.add("configs", this.configs);
        kparams.add("lockedJobs", this.lockedJobs);
        kparams.add("avgWait", this.avgWait);
        kparams.add("avgWork", this.avgWork);
        kparams.add("lastStatus", this.lastStatus);
        kparams.add("lastStatusStr", this.lastStatusStr);
        return kparams;
    }

    public static interface Tokenizer
    extends ObjectBase.Tokenizer {
        public String id();

        public String configuredId();

        public String schedulerId();

        public String schedulerConfiguredId();

        public String type();

        public String typeName();

        public String name();

        public RequestBuilder.ListTokenizer<SchedulerStatus.Tokenizer> statuses();

        public RequestBuilder.ListTokenizer<SchedulerConfig.Tokenizer> configs();

        public RequestBuilder.ListTokenizer<BatchJob.Tokenizer> lockedJobs();

        public String avgWait();

        public String avgWork();

        public String lastStatus();

        public String lastStatusStr();
    }
}

