/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.types;

import com.google.gson.JsonObject;
import com.kaltura.client.Params;
import com.kaltura.client.enums.ObjectFilterEngineType;
import com.kaltura.client.enums.ScheduledTaskProfileStatus;
import com.kaltura.client.types.APIException;
import com.kaltura.client.types.Filter;
import com.kaltura.client.types.ObjectBase;
import com.kaltura.client.types.ObjectTask;
import com.kaltura.client.utils.GsonParser;
import com.kaltura.client.utils.request.MultiRequestBuilder;
import com.kaltura.client.utils.request.RequestBuilder;
import java.util.List;

@MultiRequestBuilder.Tokenizer(value=Tokenizer.class)
public class ScheduledTaskProfile
extends ObjectBase {
    private Integer id;
    private Integer partnerId;
    private String name;
    private String systemName;
    private String description;
    private ScheduledTaskProfileStatus status;
    private ObjectFilterEngineType objectFilterEngineType;
    private Filter objectFilter;
    private List<ObjectTask> objectTasks;
    private Long createdAt;
    private Long updatedAt;
    private Long lastExecutionStartedAt;
    private Integer maxTotalCountAllowed;

    public Integer getId() {
        return this.id;
    }

    public Integer getPartnerId() {
        return this.partnerId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void name(String multirequestToken) {
        this.setToken("name", multirequestToken);
    }

    public String getSystemName() {
        return this.systemName;
    }

    public void setSystemName(String systemName) {
        this.systemName = systemName;
    }

    public void systemName(String multirequestToken) {
        this.setToken("systemName", multirequestToken);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void description(String multirequestToken) {
        this.setToken("description", multirequestToken);
    }

    public ScheduledTaskProfileStatus getStatus() {
        return this.status;
    }

    public void setStatus(ScheduledTaskProfileStatus status) {
        this.status = status;
    }

    public void status(String multirequestToken) {
        this.setToken("status", multirequestToken);
    }

    public ObjectFilterEngineType getObjectFilterEngineType() {
        return this.objectFilterEngineType;
    }

    public void setObjectFilterEngineType(ObjectFilterEngineType objectFilterEngineType) {
        this.objectFilterEngineType = objectFilterEngineType;
    }

    public void objectFilterEngineType(String multirequestToken) {
        this.setToken("objectFilterEngineType", multirequestToken);
    }

    public Filter getObjectFilter() {
        return this.objectFilter;
    }

    public void setObjectFilter(Filter objectFilter) {
        this.objectFilter = objectFilter;
    }

    public List<ObjectTask> getObjectTasks() {
        return this.objectTasks;
    }

    public void setObjectTasks(List<ObjectTask> objectTasks) {
        this.objectTasks = objectTasks;
    }

    public Long getCreatedAt() {
        return this.createdAt;
    }

    public Long getUpdatedAt() {
        return this.updatedAt;
    }

    public Long getLastExecutionStartedAt() {
        return this.lastExecutionStartedAt;
    }

    public void setLastExecutionStartedAt(Long lastExecutionStartedAt) {
        this.lastExecutionStartedAt = lastExecutionStartedAt;
    }

    public void lastExecutionStartedAt(String multirequestToken) {
        this.setToken("lastExecutionStartedAt", multirequestToken);
    }

    public Integer getMaxTotalCountAllowed() {
        return this.maxTotalCountAllowed;
    }

    public void setMaxTotalCountAllowed(Integer maxTotalCountAllowed) {
        this.maxTotalCountAllowed = maxTotalCountAllowed;
    }

    public void maxTotalCountAllowed(String multirequestToken) {
        this.setToken("maxTotalCountAllowed", multirequestToken);
    }

    public ScheduledTaskProfile() {
    }

    public ScheduledTaskProfile(JsonObject jsonObject) throws APIException {
        super(jsonObject);
        if (jsonObject == null) {
            return;
        }
        this.id = GsonParser.parseInt(jsonObject.get("id"));
        this.partnerId = GsonParser.parseInt(jsonObject.get("partnerId"));
        this.name = GsonParser.parseString(jsonObject.get("name"));
        this.systemName = GsonParser.parseString(jsonObject.get("systemName"));
        this.description = GsonParser.parseString(jsonObject.get("description"));
        this.status = ScheduledTaskProfileStatus.get(GsonParser.parseInt(jsonObject.get("status")));
        this.objectFilterEngineType = ObjectFilterEngineType.get(GsonParser.parseString(jsonObject.get("objectFilterEngineType")));
        this.objectFilter = GsonParser.parseObject(jsonObject.getAsJsonObject("objectFilter"), Filter.class);
        this.objectTasks = GsonParser.parseArray(jsonObject.getAsJsonArray("objectTasks"), ObjectTask.class);
        this.createdAt = GsonParser.parseLong(jsonObject.get("createdAt"));
        this.updatedAt = GsonParser.parseLong(jsonObject.get("updatedAt"));
        this.lastExecutionStartedAt = GsonParser.parseLong(jsonObject.get("lastExecutionStartedAt"));
        this.maxTotalCountAllowed = GsonParser.parseInt(jsonObject.get("maxTotalCountAllowed"));
    }

    @Override
    public Params toParams() {
        Params kparams = super.toParams();
        kparams.add("objectType", "KalturaScheduledTaskProfile");
        kparams.add("name", this.name);
        kparams.add("systemName", this.systemName);
        kparams.add("description", this.description);
        kparams.add("status", this.status);
        kparams.add("objectFilterEngineType", this.objectFilterEngineType);
        kparams.add("objectFilter", this.objectFilter);
        kparams.add("objectTasks", this.objectTasks);
        kparams.add("lastExecutionStartedAt", this.lastExecutionStartedAt);
        kparams.add("maxTotalCountAllowed", this.maxTotalCountAllowed);
        return kparams;
    }

    public static interface Tokenizer
    extends ObjectBase.Tokenizer {
        public String id();

        public String partnerId();

        public String name();

        public String systemName();

        public String description();

        public String status();

        public String objectFilterEngineType();

        public Filter.Tokenizer objectFilter();

        public RequestBuilder.ListTokenizer<ObjectTask.Tokenizer> objectTasks();

        public String createdAt();

        public String updatedAt();

        public String lastExecutionStartedAt();

        public String maxTotalCountAllowed();
    }
}

