/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.types;

import com.google.gson.JsonObject;
import com.kaltura.client.Params;
import com.kaltura.client.types.APIException;
import com.kaltura.client.types.ObjectBase;
import com.kaltura.client.types.ReportExportItem;
import com.kaltura.client.utils.GsonParser;
import com.kaltura.client.utils.request.MultiRequestBuilder;
import com.kaltura.client.utils.request.RequestBuilder;
import java.util.List;

@MultiRequestBuilder.Tokenizer(value=Tokenizer.class)
public class ReportExportParams
extends ObjectBase {
    private String recipientEmail;
    private Integer timeZoneOffset;
    private List<ReportExportItem> reportItems;
    private String reportsItemsGroup;
    private String baseUrl;

    public String getRecipientEmail() {
        return this.recipientEmail;
    }

    public void setRecipientEmail(String recipientEmail) {
        this.recipientEmail = recipientEmail;
    }

    public void recipientEmail(String multirequestToken) {
        this.setToken("recipientEmail", multirequestToken);
    }

    public Integer getTimeZoneOffset() {
        return this.timeZoneOffset;
    }

    public void setTimeZoneOffset(Integer timeZoneOffset) {
        this.timeZoneOffset = timeZoneOffset;
    }

    public void timeZoneOffset(String multirequestToken) {
        this.setToken("timeZoneOffset", multirequestToken);
    }

    public List<ReportExportItem> getReportItems() {
        return this.reportItems;
    }

    public void setReportItems(List<ReportExportItem> reportItems) {
        this.reportItems = reportItems;
    }

    public String getReportsItemsGroup() {
        return this.reportsItemsGroup;
    }

    public void setReportsItemsGroup(String reportsItemsGroup) {
        this.reportsItemsGroup = reportsItemsGroup;
    }

    public void reportsItemsGroup(String multirequestToken) {
        this.setToken("reportsItemsGroup", multirequestToken);
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public void baseUrl(String multirequestToken) {
        this.setToken("baseUrl", multirequestToken);
    }

    public ReportExportParams() {
    }

    public ReportExportParams(JsonObject jsonObject) throws APIException {
        super(jsonObject);
        if (jsonObject == null) {
            return;
        }
        this.recipientEmail = GsonParser.parseString(jsonObject.get("recipientEmail"));
        this.timeZoneOffset = GsonParser.parseInt(jsonObject.get("timeZoneOffset"));
        this.reportItems = GsonParser.parseArray(jsonObject.getAsJsonArray("reportItems"), ReportExportItem.class);
        this.reportsItemsGroup = GsonParser.parseString(jsonObject.get("reportsItemsGroup"));
        this.baseUrl = GsonParser.parseString(jsonObject.get("baseUrl"));
    }

    @Override
    public Params toParams() {
        Params kparams = super.toParams();
        kparams.add("objectType", "KalturaReportExportParams");
        kparams.add("recipientEmail", this.recipientEmail);
        kparams.add("timeZoneOffset", this.timeZoneOffset);
        kparams.add("reportItems", this.reportItems);
        kparams.add("reportsItemsGroup", this.reportsItemsGroup);
        kparams.add("baseUrl", this.baseUrl);
        return kparams;
    }

    public static interface Tokenizer
    extends ObjectBase.Tokenizer {
        public String recipientEmail();

        public String timeZoneOffset();

        public RequestBuilder.ListTokenizer<ReportExportItem.Tokenizer> reportItems();

        public String reportsItemsGroup();

        public String baseUrl();
    }
}

