/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.types;

import com.google.gson.JsonObject;
import com.kaltura.client.Params;
import com.kaltura.client.types.APIException;
import com.kaltura.client.types.JobData;
import com.kaltura.client.types.ReportExportFile;
import com.kaltura.client.types.ReportExportItem;
import com.kaltura.client.utils.GsonParser;
import com.kaltura.client.utils.request.MultiRequestBuilder;
import com.kaltura.client.utils.request.RequestBuilder;
import java.util.List;

@MultiRequestBuilder.Tokenizer(value=Tokenizer.class)
public class ReportExportJobData
extends JobData {
    private String recipientEmail;
    private List<ReportExportItem> reportItems;
    private String filePaths;
    private String reportsGroup;
    private List<ReportExportFile> files;
    private String baseUrl;

    public String getRecipientEmail() {
        return this.recipientEmail;
    }

    public void setRecipientEmail(String recipientEmail) {
        this.recipientEmail = recipientEmail;
    }

    public void recipientEmail(String multirequestToken) {
        this.setToken("recipientEmail", multirequestToken);
    }

    public List<ReportExportItem> getReportItems() {
        return this.reportItems;
    }

    public void setReportItems(List<ReportExportItem> reportItems) {
        this.reportItems = reportItems;
    }

    public String getFilePaths() {
        return this.filePaths;
    }

    public void setFilePaths(String filePaths) {
        this.filePaths = filePaths;
    }

    public void filePaths(String multirequestToken) {
        this.setToken("filePaths", multirequestToken);
    }

    public String getReportsGroup() {
        return this.reportsGroup;
    }

    public void setReportsGroup(String reportsGroup) {
        this.reportsGroup = reportsGroup;
    }

    public void reportsGroup(String multirequestToken) {
        this.setToken("reportsGroup", multirequestToken);
    }

    public List<ReportExportFile> getFiles() {
        return this.files;
    }

    public void setFiles(List<ReportExportFile> files) {
        this.files = files;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public void baseUrl(String multirequestToken) {
        this.setToken("baseUrl", multirequestToken);
    }

    public ReportExportJobData() {
    }

    public ReportExportJobData(JsonObject jsonObject) throws APIException {
        super(jsonObject);
        if (jsonObject == null) {
            return;
        }
        this.recipientEmail = GsonParser.parseString(jsonObject.get("recipientEmail"));
        this.reportItems = GsonParser.parseArray(jsonObject.getAsJsonArray("reportItems"), ReportExportItem.class);
        this.filePaths = GsonParser.parseString(jsonObject.get("filePaths"));
        this.reportsGroup = GsonParser.parseString(jsonObject.get("reportsGroup"));
        this.files = GsonParser.parseArray(jsonObject.getAsJsonArray("files"), ReportExportFile.class);
        this.baseUrl = GsonParser.parseString(jsonObject.get("baseUrl"));
    }

    @Override
    public Params toParams() {
        Params kparams = super.toParams();
        kparams.add("objectType", "KalturaReportExportJobData");
        kparams.add("recipientEmail", this.recipientEmail);
        kparams.add("reportItems", this.reportItems);
        kparams.add("filePaths", this.filePaths);
        kparams.add("reportsGroup", this.reportsGroup);
        kparams.add("files", this.files);
        kparams.add("baseUrl", this.baseUrl);
        return kparams;
    }

    public static interface Tokenizer
    extends JobData.Tokenizer {
        public String recipientEmail();

        public RequestBuilder.ListTokenizer<ReportExportItem.Tokenizer> reportItems();

        public String filePaths();

        public String reportsGroup();

        public RequestBuilder.ListTokenizer<ReportExportFile.Tokenizer> files();

        public String baseUrl();
    }
}

