/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.types;

import com.google.gson.JsonObject;
import com.kaltura.client.Params;
import com.kaltura.client.enums.ResponseType;
import com.kaltura.client.types.APIException;
import com.kaltura.client.types.EventNotificationTemplate;
import com.kaltura.client.types.PushEventNotificationParameter;
import com.kaltura.client.utils.GsonParser;
import com.kaltura.client.utils.request.MultiRequestBuilder;
import com.kaltura.client.utils.request.RequestBuilder;
import java.util.List;

@MultiRequestBuilder.Tokenizer(value=Tokenizer.class)
public class PushNotificationTemplate
extends EventNotificationTemplate {
    private List<PushEventNotificationParameter> queueNameParameters;
    private List<PushEventNotificationParameter> queueKeyParameters;
    private String apiObjectType;
    private ResponseType objectFormat;
    private Integer responseProfileId;

    public List<PushEventNotificationParameter> getQueueNameParameters() {
        return this.queueNameParameters;
    }

    public void setQueueNameParameters(List<PushEventNotificationParameter> queueNameParameters) {
        this.queueNameParameters = queueNameParameters;
    }

    public List<PushEventNotificationParameter> getQueueKeyParameters() {
        return this.queueKeyParameters;
    }

    public void setQueueKeyParameters(List<PushEventNotificationParameter> queueKeyParameters) {
        this.queueKeyParameters = queueKeyParameters;
    }

    public String getApiObjectType() {
        return this.apiObjectType;
    }

    public void setApiObjectType(String apiObjectType) {
        this.apiObjectType = apiObjectType;
    }

    public void apiObjectType(String multirequestToken) {
        this.setToken("apiObjectType", multirequestToken);
    }

    public ResponseType getObjectFormat() {
        return this.objectFormat;
    }

    public void setObjectFormat(ResponseType objectFormat) {
        this.objectFormat = objectFormat;
    }

    public void objectFormat(String multirequestToken) {
        this.setToken("objectFormat", multirequestToken);
    }

    public Integer getResponseProfileId() {
        return this.responseProfileId;
    }

    public void setResponseProfileId(Integer responseProfileId) {
        this.responseProfileId = responseProfileId;
    }

    public void responseProfileId(String multirequestToken) {
        this.setToken("responseProfileId", multirequestToken);
    }

    public PushNotificationTemplate() {
    }

    public PushNotificationTemplate(JsonObject jsonObject) throws APIException {
        super(jsonObject);
        if (jsonObject == null) {
            return;
        }
        this.queueNameParameters = GsonParser.parseArray(jsonObject.getAsJsonArray("queueNameParameters"), PushEventNotificationParameter.class);
        this.queueKeyParameters = GsonParser.parseArray(jsonObject.getAsJsonArray("queueKeyParameters"), PushEventNotificationParameter.class);
        this.apiObjectType = GsonParser.parseString(jsonObject.get("apiObjectType"));
        this.objectFormat = ResponseType.get(GsonParser.parseInt(jsonObject.get("objectFormat")));
        this.responseProfileId = GsonParser.parseInt(jsonObject.get("responseProfileId"));
    }

    @Override
    public Params toParams() {
        Params kparams = super.toParams();
        kparams.add("objectType", "KalturaPushNotificationTemplate");
        kparams.add("queueNameParameters", this.queueNameParameters);
        kparams.add("queueKeyParameters", this.queueKeyParameters);
        kparams.add("apiObjectType", this.apiObjectType);
        kparams.add("objectFormat", this.objectFormat);
        kparams.add("responseProfileId", this.responseProfileId);
        return kparams;
    }

    public static interface Tokenizer
    extends EventNotificationTemplate.Tokenizer {
        public RequestBuilder.ListTokenizer<PushEventNotificationParameter.Tokenizer> queueNameParameters();

        public RequestBuilder.ListTokenizer<PushEventNotificationParameter.Tokenizer> queueKeyParameters();

        public String apiObjectType();

        public String objectFormat();

        public String responseProfileId();
    }
}

