/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.types;

import com.google.gson.JsonObject;
import com.kaltura.client.Params;
import com.kaltura.client.types.APIException;
import com.kaltura.client.types.DrmPlaybackPluginData;
import com.kaltura.client.types.ObjectBase;
import com.kaltura.client.utils.GsonParser;
import com.kaltura.client.utils.request.MultiRequestBuilder;
import com.kaltura.client.utils.request.RequestBuilder;
import java.util.List;

@MultiRequestBuilder.Tokenizer(value=Tokenizer.class)
public class PlaybackSource
extends ObjectBase {
    private String deliveryProfileId;
    private String format;
    private String protocols;
    private String flavorIds;
    private String url;
    private List<DrmPlaybackPluginData> drm;

    public String getDeliveryProfileId() {
        return this.deliveryProfileId;
    }

    public void setDeliveryProfileId(String deliveryProfileId) {
        this.deliveryProfileId = deliveryProfileId;
    }

    public void deliveryProfileId(String multirequestToken) {
        this.setToken("deliveryProfileId", multirequestToken);
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void format(String multirequestToken) {
        this.setToken("format", multirequestToken);
    }

    public String getProtocols() {
        return this.protocols;
    }

    public void setProtocols(String protocols) {
        this.protocols = protocols;
    }

    public void protocols(String multirequestToken) {
        this.setToken("protocols", multirequestToken);
    }

    public String getFlavorIds() {
        return this.flavorIds;
    }

    public void setFlavorIds(String flavorIds) {
        this.flavorIds = flavorIds;
    }

    public void flavorIds(String multirequestToken) {
        this.setToken("flavorIds", multirequestToken);
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void url(String multirequestToken) {
        this.setToken("url", multirequestToken);
    }

    public List<DrmPlaybackPluginData> getDrm() {
        return this.drm;
    }

    public void setDrm(List<DrmPlaybackPluginData> drm) {
        this.drm = drm;
    }

    public PlaybackSource() {
    }

    public PlaybackSource(JsonObject jsonObject) throws APIException {
        super(jsonObject);
        if (jsonObject == null) {
            return;
        }
        this.deliveryProfileId = GsonParser.parseString(jsonObject.get("deliveryProfileId"));
        this.format = GsonParser.parseString(jsonObject.get("format"));
        this.protocols = GsonParser.parseString(jsonObject.get("protocols"));
        this.flavorIds = GsonParser.parseString(jsonObject.get("flavorIds"));
        this.url = GsonParser.parseString(jsonObject.get("url"));
        this.drm = GsonParser.parseArray(jsonObject.getAsJsonArray("drm"), DrmPlaybackPluginData.class);
    }

    @Override
    public Params toParams() {
        Params kparams = super.toParams();
        kparams.add("objectType", "KalturaPlaybackSource");
        kparams.add("deliveryProfileId", this.deliveryProfileId);
        kparams.add("format", this.format);
        kparams.add("protocols", this.protocols);
        kparams.add("flavorIds", this.flavorIds);
        kparams.add("url", this.url);
        kparams.add("drm", this.drm);
        return kparams;
    }

    public static interface Tokenizer
    extends ObjectBase.Tokenizer {
        public String deliveryProfileId();

        public String format();

        public String protocols();

        public String flavorIds();

        public String url();

        public RequestBuilder.ListTokenizer<DrmPlaybackPluginData.Tokenizer> drm();
    }
}

