/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.types;

import com.google.gson.JsonObject;
import com.kaltura.client.Params;
import com.kaltura.client.types.APIException;
import com.kaltura.client.types.ObjectBase;
import com.kaltura.client.utils.GsonParser;
import com.kaltura.client.utils.request.MultiRequestBuilder;

@MultiRequestBuilder.Tokenizer(value=Tokenizer.class)
public class PartnerStatistics
extends ObjectBase {
    private Integer packageBandwidthAndStorage;
    private Double hosting;
    private Double bandwidth;
    private Integer usage;
    private Double usagePercent;
    private Integer reachedLimitDate;

    public Integer getPackageBandwidthAndStorage() {
        return this.packageBandwidthAndStorage;
    }

    public Double getHosting() {
        return this.hosting;
    }

    public Double getBandwidth() {
        return this.bandwidth;
    }

    public Integer getUsage() {
        return this.usage;
    }

    public Double getUsagePercent() {
        return this.usagePercent;
    }

    public Integer getReachedLimitDate() {
        return this.reachedLimitDate;
    }

    public PartnerStatistics() {
    }

    public PartnerStatistics(JsonObject jsonObject) throws APIException {
        super(jsonObject);
        if (jsonObject == null) {
            return;
        }
        this.packageBandwidthAndStorage = GsonParser.parseInt(jsonObject.get("packageBandwidthAndStorage"));
        this.hosting = GsonParser.parseDouble(jsonObject.get("hosting"));
        this.bandwidth = GsonParser.parseDouble(jsonObject.get("bandwidth"));
        this.usage = GsonParser.parseInt(jsonObject.get("usage"));
        this.usagePercent = GsonParser.parseDouble(jsonObject.get("usagePercent"));
        this.reachedLimitDate = GsonParser.parseInt(jsonObject.get("reachedLimitDate"));
    }

    @Override
    public Params toParams() {
        Params kparams = super.toParams();
        kparams.add("objectType", "KalturaPartnerStatistics");
        return kparams;
    }

    public static interface Tokenizer
    extends ObjectBase.Tokenizer {
        public String packageBandwidthAndStorage();

        public String hosting();

        public String bandwidth();

        public String usage();

        public String usagePercent();

        public String reachedLimitDate();
    }
}

