/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.types;

import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.kaltura.client.Params;
import com.kaltura.client.types.APIException;
import com.kaltura.client.types.ObjectBase;
import com.kaltura.client.utils.GsonParser;
import com.kaltura.client.utils.request.RequestBuilder;
import java.util.List;

public class ListResponse<T>
extends ObjectBase {
    private int totalCount = Integer.MIN_VALUE;
    private List<T> objects;

    public int getTotalCount() {
        return this.totalCount;
    }

    public void setTotalCount(int totalCount) {
        this.totalCount = totalCount;
    }

    public List<T> getObjects() {
        return this.objects;
    }

    public void setObjects(List<T> objects) {
        this.objects = objects;
    }

    public ListResponse() {
    }

    public ListResponse(JsonObject jsonObject) throws APIException {
        if (jsonObject == null) {
            return;
        }
        Class<ObjectBase> cls = ObjectBase.class;
        JsonPrimitive objectTypeElement = jsonObject.getAsJsonPrimitive("objectType");
        if (objectTypeElement != null) {
            String objectType = objectTypeElement.getAsString().replaceAll("ListResponse$", "");
            cls = GsonParser.getObjectClass(objectType, cls);
        }
        this.totalCount = GsonParser.parseInt(jsonObject.get("totalCount"));
        this.objects = GsonParser.parseArray(jsonObject.getAsJsonArray("objects"), cls);
    }

    @Override
    public Params toParams() {
        Params kparams = super.toParams();
        kparams.add("objectType", "KalturaListResponse");
        return kparams;
    }

    public static interface Tokenizer<T> {
        public String totalCount();

        public RequestBuilder.ListTokenizer<T> objects();
    }
}

