/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.types;

import com.google.gson.JsonObject;
import com.kaltura.client.Params;
import com.kaltura.client.types.APIException;
import com.kaltura.client.types.ConfigurableDistributionJobProviderData;
import com.kaltura.client.types.CuePoint;
import com.kaltura.client.types.StringHolder;
import com.kaltura.client.utils.GsonParser;
import com.kaltura.client.utils.request.MultiRequestBuilder;
import com.kaltura.client.utils.request.RequestBuilder;
import java.util.List;

@MultiRequestBuilder.Tokenizer(value=Tokenizer.class)
public class HuluDistributionJobProviderData
extends ConfigurableDistributionJobProviderData {
    private String videoAssetFilePath;
    private String thumbAssetFilePath;
    private List<CuePoint> cuePoints;
    private String fileBaseName;
    private List<StringHolder> captionLocalPaths;

    public String getVideoAssetFilePath() {
        return this.videoAssetFilePath;
    }

    public void setVideoAssetFilePath(String videoAssetFilePath) {
        this.videoAssetFilePath = videoAssetFilePath;
    }

    public void videoAssetFilePath(String multirequestToken) {
        this.setToken("videoAssetFilePath", multirequestToken);
    }

    public String getThumbAssetFilePath() {
        return this.thumbAssetFilePath;
    }

    public void setThumbAssetFilePath(String thumbAssetFilePath) {
        this.thumbAssetFilePath = thumbAssetFilePath;
    }

    public void thumbAssetFilePath(String multirequestToken) {
        this.setToken("thumbAssetFilePath", multirequestToken);
    }

    public List<CuePoint> getCuePoints() {
        return this.cuePoints;
    }

    public void setCuePoints(List<CuePoint> cuePoints) {
        this.cuePoints = cuePoints;
    }

    public String getFileBaseName() {
        return this.fileBaseName;
    }

    public void setFileBaseName(String fileBaseName) {
        this.fileBaseName = fileBaseName;
    }

    public void fileBaseName(String multirequestToken) {
        this.setToken("fileBaseName", multirequestToken);
    }

    public List<StringHolder> getCaptionLocalPaths() {
        return this.captionLocalPaths;
    }

    public void setCaptionLocalPaths(List<StringHolder> captionLocalPaths) {
        this.captionLocalPaths = captionLocalPaths;
    }

    public HuluDistributionJobProviderData() {
    }

    public HuluDistributionJobProviderData(JsonObject jsonObject) throws APIException {
        super(jsonObject);
        if (jsonObject == null) {
            return;
        }
        this.videoAssetFilePath = GsonParser.parseString(jsonObject.get("videoAssetFilePath"));
        this.thumbAssetFilePath = GsonParser.parseString(jsonObject.get("thumbAssetFilePath"));
        this.cuePoints = GsonParser.parseArray(jsonObject.getAsJsonArray("cuePoints"), CuePoint.class);
        this.fileBaseName = GsonParser.parseString(jsonObject.get("fileBaseName"));
        this.captionLocalPaths = GsonParser.parseArray(jsonObject.getAsJsonArray("captionLocalPaths"), StringHolder.class);
    }

    @Override
    public Params toParams() {
        Params kparams = super.toParams();
        kparams.add("objectType", "KalturaHuluDistributionJobProviderData");
        kparams.add("videoAssetFilePath", this.videoAssetFilePath);
        kparams.add("thumbAssetFilePath", this.thumbAssetFilePath);
        kparams.add("cuePoints", this.cuePoints);
        kparams.add("fileBaseName", this.fileBaseName);
        kparams.add("captionLocalPaths", this.captionLocalPaths);
        return kparams;
    }

    public static interface Tokenizer
    extends ConfigurableDistributionJobProviderData.Tokenizer {
        public String videoAssetFilePath();

        public String thumbAssetFilePath();

        public RequestBuilder.ListTokenizer<CuePoint.Tokenizer> cuePoints();

        public String fileBaseName();

        public RequestBuilder.ListTokenizer<StringHolder.Tokenizer> captionLocalPaths();
    }
}

