/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.types;

import com.google.gson.JsonObject;
import com.kaltura.client.Params;
import com.kaltura.client.enums.ResponseType;
import com.kaltura.client.types.APIException;
import com.kaltura.client.types.HttpNotificationData;
import com.kaltura.client.types.KeyValue;
import com.kaltura.client.utils.GsonParser;
import com.kaltura.client.utils.request.MultiRequestBuilder;
import com.kaltura.client.utils.request.RequestBuilder;
import java.util.List;

@MultiRequestBuilder.Tokenizer(value=Tokenizer.class)
public class HttpNotificationObjectData
extends HttpNotificationData {
    private String apiObjectType;
    private ResponseType format;
    private Boolean ignoreNull;
    private String code;
    private List<KeyValue> dataStringReplacements;

    public String getApiObjectType() {
        return this.apiObjectType;
    }

    public void setApiObjectType(String apiObjectType) {
        this.apiObjectType = apiObjectType;
    }

    public void apiObjectType(String multirequestToken) {
        this.setToken("apiObjectType", multirequestToken);
    }

    public ResponseType getFormat() {
        return this.format;
    }

    public void setFormat(ResponseType format) {
        this.format = format;
    }

    public void format(String multirequestToken) {
        this.setToken("format", multirequestToken);
    }

    public Boolean getIgnoreNull() {
        return this.ignoreNull;
    }

    public void setIgnoreNull(Boolean ignoreNull) {
        this.ignoreNull = ignoreNull;
    }

    public void ignoreNull(String multirequestToken) {
        this.setToken("ignoreNull", multirequestToken);
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void code(String multirequestToken) {
        this.setToken("code", multirequestToken);
    }

    public List<KeyValue> getDataStringReplacements() {
        return this.dataStringReplacements;
    }

    public void setDataStringReplacements(List<KeyValue> dataStringReplacements) {
        this.dataStringReplacements = dataStringReplacements;
    }

    public HttpNotificationObjectData() {
    }

    public HttpNotificationObjectData(JsonObject jsonObject) throws APIException {
        super(jsonObject);
        if (jsonObject == null) {
            return;
        }
        this.apiObjectType = GsonParser.parseString(jsonObject.get("apiObjectType"));
        this.format = ResponseType.get(GsonParser.parseInt(jsonObject.get("format")));
        this.ignoreNull = GsonParser.parseBoolean(jsonObject.get("ignoreNull"));
        this.code = GsonParser.parseString(jsonObject.get("code"));
        this.dataStringReplacements = GsonParser.parseArray(jsonObject.getAsJsonArray("dataStringReplacements"), KeyValue.class);
    }

    @Override
    public Params toParams() {
        Params kparams = super.toParams();
        kparams.add("objectType", "KalturaHttpNotificationObjectData");
        kparams.add("apiObjectType", this.apiObjectType);
        kparams.add("format", this.format);
        kparams.add("ignoreNull", this.ignoreNull);
        kparams.add("code", this.code);
        kparams.add("dataStringReplacements", this.dataStringReplacements);
        return kparams;
    }

    public static interface Tokenizer
    extends HttpNotificationData.Tokenizer {
        public String apiObjectType();

        public String format();

        public String ignoreNull();

        public String code();

        public RequestBuilder.ListTokenizer<KeyValue.Tokenizer> dataStringReplacements();
    }
}

