/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.types;

import com.google.gson.JsonObject;
import com.kaltura.client.Params;
import com.kaltura.client.enums.EmailNotificationTemplatePriority;
import com.kaltura.client.types.APIException;
import com.kaltura.client.types.EmailNotificationRecipientJobData;
import com.kaltura.client.types.EventNotificationDispatchJobData;
import com.kaltura.client.types.KeyValue;
import com.kaltura.client.utils.GsonParser;
import com.kaltura.client.utils.request.MultiRequestBuilder;
import com.kaltura.client.utils.request.RequestBuilder;
import java.util.List;

@MultiRequestBuilder.Tokenizer(value=Tokenizer.class)
public class EmailNotificationDispatchJobData
extends EventNotificationDispatchJobData {
    private String fromEmail;
    private String fromName;
    private EmailNotificationRecipientJobData to;
    private EmailNotificationRecipientJobData cc;
    private EmailNotificationRecipientJobData bcc;
    private EmailNotificationRecipientJobData replyTo;
    private EmailNotificationTemplatePriority priority;
    private String confirmReadingTo;
    private String hostname;
    private String messageID;
    private List<KeyValue> customHeaders;

    public String getFromEmail() {
        return this.fromEmail;
    }

    public void setFromEmail(String fromEmail) {
        this.fromEmail = fromEmail;
    }

    public void fromEmail(String multirequestToken) {
        this.setToken("fromEmail", multirequestToken);
    }

    public String getFromName() {
        return this.fromName;
    }

    public void setFromName(String fromName) {
        this.fromName = fromName;
    }

    public void fromName(String multirequestToken) {
        this.setToken("fromName", multirequestToken);
    }

    public EmailNotificationRecipientJobData getTo() {
        return this.to;
    }

    public void setTo(EmailNotificationRecipientJobData to) {
        this.to = to;
    }

    public EmailNotificationRecipientJobData getCc() {
        return this.cc;
    }

    public void setCc(EmailNotificationRecipientJobData cc) {
        this.cc = cc;
    }

    public EmailNotificationRecipientJobData getBcc() {
        return this.bcc;
    }

    public void setBcc(EmailNotificationRecipientJobData bcc) {
        this.bcc = bcc;
    }

    public EmailNotificationRecipientJobData getReplyTo() {
        return this.replyTo;
    }

    public void setReplyTo(EmailNotificationRecipientJobData replyTo) {
        this.replyTo = replyTo;
    }

    public EmailNotificationTemplatePriority getPriority() {
        return this.priority;
    }

    public void setPriority(EmailNotificationTemplatePriority priority) {
        this.priority = priority;
    }

    public void priority(String multirequestToken) {
        this.setToken("priority", multirequestToken);
    }

    public String getConfirmReadingTo() {
        return this.confirmReadingTo;
    }

    public void setConfirmReadingTo(String confirmReadingTo) {
        this.confirmReadingTo = confirmReadingTo;
    }

    public void confirmReadingTo(String multirequestToken) {
        this.setToken("confirmReadingTo", multirequestToken);
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public void hostname(String multirequestToken) {
        this.setToken("hostname", multirequestToken);
    }

    public String getMessageID() {
        return this.messageID;
    }

    public void setMessageID(String messageID) {
        this.messageID = messageID;
    }

    public void messageID(String multirequestToken) {
        this.setToken("messageID", multirequestToken);
    }

    public List<KeyValue> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(List<KeyValue> customHeaders) {
        this.customHeaders = customHeaders;
    }

    public EmailNotificationDispatchJobData() {
    }

    public EmailNotificationDispatchJobData(JsonObject jsonObject) throws APIException {
        super(jsonObject);
        if (jsonObject == null) {
            return;
        }
        this.fromEmail = GsonParser.parseString(jsonObject.get("fromEmail"));
        this.fromName = GsonParser.parseString(jsonObject.get("fromName"));
        this.to = GsonParser.parseObject(jsonObject.getAsJsonObject("to"), EmailNotificationRecipientJobData.class);
        this.cc = GsonParser.parseObject(jsonObject.getAsJsonObject("cc"), EmailNotificationRecipientJobData.class);
        this.bcc = GsonParser.parseObject(jsonObject.getAsJsonObject("bcc"), EmailNotificationRecipientJobData.class);
        this.replyTo = GsonParser.parseObject(jsonObject.getAsJsonObject("replyTo"), EmailNotificationRecipientJobData.class);
        this.priority = EmailNotificationTemplatePriority.get(GsonParser.parseInt(jsonObject.get("priority")));
        this.confirmReadingTo = GsonParser.parseString(jsonObject.get("confirmReadingTo"));
        this.hostname = GsonParser.parseString(jsonObject.get("hostname"));
        this.messageID = GsonParser.parseString(jsonObject.get("messageID"));
        this.customHeaders = GsonParser.parseArray(jsonObject.getAsJsonArray("customHeaders"), KeyValue.class);
    }

    @Override
    public Params toParams() {
        Params kparams = super.toParams();
        kparams.add("objectType", "KalturaEmailNotificationDispatchJobData");
        kparams.add("fromEmail", this.fromEmail);
        kparams.add("fromName", this.fromName);
        kparams.add("to", this.to);
        kparams.add("cc", this.cc);
        kparams.add("bcc", this.bcc);
        kparams.add("replyTo", this.replyTo);
        kparams.add("priority", this.priority);
        kparams.add("confirmReadingTo", this.confirmReadingTo);
        kparams.add("hostname", this.hostname);
        kparams.add("messageID", this.messageID);
        kparams.add("customHeaders", this.customHeaders);
        return kparams;
    }

    public static interface Tokenizer
    extends EventNotificationDispatchJobData.Tokenizer {
        public String fromEmail();

        public String fromName();

        public EmailNotificationRecipientJobData.Tokenizer to();

        public EmailNotificationRecipientJobData.Tokenizer cc();

        public EmailNotificationRecipientJobData.Tokenizer bcc();

        public EmailNotificationRecipientJobData.Tokenizer replyTo();

        public String priority();

        public String confirmReadingTo();

        public String hostname();

        public String messageID();

        public RequestBuilder.ListTokenizer<KeyValue.Tokenizer> customHeaders();
    }
}

