/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.types;

import com.google.gson.JsonObject;
import com.kaltura.client.Params;
import com.kaltura.client.enums.ESearchOperatorType;
import com.kaltura.client.types.APIException;
import com.kaltura.client.types.ESearchEntryBaseItem;
import com.kaltura.client.utils.GsonParser;
import com.kaltura.client.utils.request.MultiRequestBuilder;
import com.kaltura.client.utils.request.RequestBuilder;
import java.util.List;

@MultiRequestBuilder.Tokenizer(value=Tokenizer.class)
public class ESearchEntryOperator
extends ESearchEntryBaseItem {
    private ESearchOperatorType operator;
    private List<ESearchEntryBaseItem> searchItems;

    public ESearchOperatorType getOperator() {
        return this.operator;
    }

    public void setOperator(ESearchOperatorType operator) {
        this.operator = operator;
    }

    public void operator(String multirequestToken) {
        this.setToken("operator", multirequestToken);
    }

    public List<ESearchEntryBaseItem> getSearchItems() {
        return this.searchItems;
    }

    public void setSearchItems(List<ESearchEntryBaseItem> searchItems) {
        this.searchItems = searchItems;
    }

    public ESearchEntryOperator() {
    }

    public ESearchEntryOperator(JsonObject jsonObject) throws APIException {
        super(jsonObject);
        if (jsonObject == null) {
            return;
        }
        this.operator = ESearchOperatorType.get(GsonParser.parseInt(jsonObject.get("operator")));
        this.searchItems = GsonParser.parseArray(jsonObject.getAsJsonArray("searchItems"), ESearchEntryBaseItem.class);
    }

    @Override
    public Params toParams() {
        Params kparams = super.toParams();
        kparams.add("objectType", "KalturaESearchEntryOperator");
        kparams.add("operator", this.operator);
        kparams.add("searchItems", this.searchItems);
        return kparams;
    }

    public static interface Tokenizer
    extends ESearchEntryBaseItem.Tokenizer {
        public String operator();

        public RequestBuilder.ListTokenizer<ESearchEntryBaseItem.Tokenizer> searchItems();
    }
}

