/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.types;

import com.google.gson.JsonObject;
import com.kaltura.client.Params;
import com.kaltura.client.enums.DeliveryProfileType;
import com.kaltura.client.enums.DeliveryStatus;
import com.kaltura.client.enums.PlaybackProtocol;
import com.kaltura.client.types.APIException;
import com.kaltura.client.types.AssetFilter;
import com.kaltura.client.types.ObjectBase;
import com.kaltura.client.types.UrlRecognizer;
import com.kaltura.client.types.UrlTokenizer;
import com.kaltura.client.utils.GsonParser;
import com.kaltura.client.utils.request.MultiRequestBuilder;

@MultiRequestBuilder.Tokenizer(value=Tokenizer.class)
public class DeliveryProfile
extends ObjectBase {
    private Integer id;
    private Integer partnerId;
    private String name;
    private DeliveryProfileType type;
    private String systemName;
    private String description;
    private Long createdAt;
    private Long updatedAt;
    private PlaybackProtocol streamerType;
    private String url;
    private String hostName;
    private DeliveryStatus status;
    private UrlRecognizer recognizer;
    private UrlTokenizer tokenizer;
    private Boolean isDefault;
    private Integer parentId;
    private String mediaProtocols;
    private Integer priority;
    private String extraParams;
    private AssetFilter supplementaryAssetsFilter;

    public Integer getId() {
        return this.id;
    }

    public Integer getPartnerId() {
        return this.partnerId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void name(String multirequestToken) {
        this.setToken("name", multirequestToken);
    }

    public DeliveryProfileType getType() {
        return this.type;
    }

    public void setType(DeliveryProfileType type) {
        this.type = type;
    }

    public void type(String multirequestToken) {
        this.setToken("type", multirequestToken);
    }

    public String getSystemName() {
        return this.systemName;
    }

    public void setSystemName(String systemName) {
        this.systemName = systemName;
    }

    public void systemName(String multirequestToken) {
        this.setToken("systemName", multirequestToken);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void description(String multirequestToken) {
        this.setToken("description", multirequestToken);
    }

    public Long getCreatedAt() {
        return this.createdAt;
    }

    public Long getUpdatedAt() {
        return this.updatedAt;
    }

    public PlaybackProtocol getStreamerType() {
        return this.streamerType;
    }

    public void setStreamerType(PlaybackProtocol streamerType) {
        this.streamerType = streamerType;
    }

    public void streamerType(String multirequestToken) {
        this.setToken("streamerType", multirequestToken);
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void url(String multirequestToken) {
        this.setToken("url", multirequestToken);
    }

    public String getHostName() {
        return this.hostName;
    }

    public DeliveryStatus getStatus() {
        return this.status;
    }

    public void setStatus(DeliveryStatus status) {
        this.status = status;
    }

    public void status(String multirequestToken) {
        this.setToken("status", multirequestToken);
    }

    public UrlRecognizer getRecognizer() {
        return this.recognizer;
    }

    public void setRecognizer(UrlRecognizer recognizer) {
        this.recognizer = recognizer;
    }

    public UrlTokenizer getTokenizer() {
        return this.tokenizer;
    }

    public void setTokenizer(UrlTokenizer tokenizer) {
        this.tokenizer = tokenizer;
    }

    public Boolean getIsDefault() {
        return this.isDefault;
    }

    public Integer getParentId() {
        return this.parentId;
    }

    public String getMediaProtocols() {
        return this.mediaProtocols;
    }

    public void setMediaProtocols(String mediaProtocols) {
        this.mediaProtocols = mediaProtocols;
    }

    public void mediaProtocols(String multirequestToken) {
        this.setToken("mediaProtocols", multirequestToken);
    }

    public Integer getPriority() {
        return this.priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public void priority(String multirequestToken) {
        this.setToken("priority", multirequestToken);
    }

    public String getExtraParams() {
        return this.extraParams;
    }

    public void setExtraParams(String extraParams) {
        this.extraParams = extraParams;
    }

    public void extraParams(String multirequestToken) {
        this.setToken("extraParams", multirequestToken);
    }

    public AssetFilter getSupplementaryAssetsFilter() {
        return this.supplementaryAssetsFilter;
    }

    public void setSupplementaryAssetsFilter(AssetFilter supplementaryAssetsFilter) {
        this.supplementaryAssetsFilter = supplementaryAssetsFilter;
    }

    public DeliveryProfile() {
    }

    public DeliveryProfile(JsonObject jsonObject) throws APIException {
        super(jsonObject);
        if (jsonObject == null) {
            return;
        }
        this.id = GsonParser.parseInt(jsonObject.get("id"));
        this.partnerId = GsonParser.parseInt(jsonObject.get("partnerId"));
        this.name = GsonParser.parseString(jsonObject.get("name"));
        this.type = DeliveryProfileType.get(GsonParser.parseString(jsonObject.get("type")));
        this.systemName = GsonParser.parseString(jsonObject.get("systemName"));
        this.description = GsonParser.parseString(jsonObject.get("description"));
        this.createdAt = GsonParser.parseLong(jsonObject.get("createdAt"));
        this.updatedAt = GsonParser.parseLong(jsonObject.get("updatedAt"));
        this.streamerType = PlaybackProtocol.get(GsonParser.parseString(jsonObject.get("streamerType")));
        this.url = GsonParser.parseString(jsonObject.get("url"));
        this.hostName = GsonParser.parseString(jsonObject.get("hostName"));
        this.status = DeliveryStatus.get(GsonParser.parseInt(jsonObject.get("status")));
        this.recognizer = GsonParser.parseObject(jsonObject.getAsJsonObject("recognizer"), UrlRecognizer.class);
        this.tokenizer = GsonParser.parseObject(jsonObject.getAsJsonObject("tokenizer"), UrlTokenizer.class);
        this.isDefault = GsonParser.parseBoolean(jsonObject.get("isDefault"));
        this.parentId = GsonParser.parseInt(jsonObject.get("parentId"));
        this.mediaProtocols = GsonParser.parseString(jsonObject.get("mediaProtocols"));
        this.priority = GsonParser.parseInt(jsonObject.get("priority"));
        this.extraParams = GsonParser.parseString(jsonObject.get("extraParams"));
        this.supplementaryAssetsFilter = GsonParser.parseObject(jsonObject.getAsJsonObject("supplementaryAssetsFilter"), AssetFilter.class);
    }

    @Override
    public Params toParams() {
        Params kparams = super.toParams();
        kparams.add("objectType", "KalturaDeliveryProfile");
        kparams.add("name", this.name);
        kparams.add("type", this.type);
        kparams.add("systemName", this.systemName);
        kparams.add("description", this.description);
        kparams.add("streamerType", this.streamerType);
        kparams.add("url", this.url);
        kparams.add("status", this.status);
        kparams.add("recognizer", this.recognizer);
        kparams.add("tokenizer", this.tokenizer);
        kparams.add("mediaProtocols", this.mediaProtocols);
        kparams.add("priority", this.priority);
        kparams.add("extraParams", this.extraParams);
        kparams.add("supplementaryAssetsFilter", this.supplementaryAssetsFilter);
        return kparams;
    }

    public static interface Tokenizer
    extends ObjectBase.Tokenizer {
        public String id();

        public String partnerId();

        public String name();

        public String type();

        public String systemName();

        public String description();

        public String createdAt();

        public String updatedAt();

        public String streamerType();

        public String url();

        public String hostName();

        public String status();

        public UrlRecognizer.Tokenizer recognizer();

        public UrlTokenizer.Tokenizer tokenizer();

        public String isDefault();

        public String parentId();

        public String mediaProtocols();

        public String priority();

        public String extraParams();

        public AssetFilter.Tokenizer supplementaryAssetsFilter();
    }
}

