/*
 * Decompiled with CFR 0.152.
 */
package com.kaltura.client.types;

import com.google.gson.JsonObject;
import com.kaltura.client.Params;
import com.kaltura.client.types.APIException;
import com.kaltura.client.types.JobData;
import com.kaltura.client.types.StringHolder;
import com.kaltura.client.utils.GsonParser;
import com.kaltura.client.utils.request.MultiRequestBuilder;
import com.kaltura.client.utils.request.RequestBuilder;
import java.util.List;

@MultiRequestBuilder.Tokenizer(value=Tokenizer.class)
public class ConcatJobData
extends JobData {
    private List<StringHolder> srcFiles;
    private String destFilePath;
    private String flavorAssetId;
    private Double offset;
    private Double duration;
    private Double concatenatedDuration;
    private Boolean shouldSort;

    public List<StringHolder> getSrcFiles() {
        return this.srcFiles;
    }

    public void setSrcFiles(List<StringHolder> srcFiles) {
        this.srcFiles = srcFiles;
    }

    public String getDestFilePath() {
        return this.destFilePath;
    }

    public void setDestFilePath(String destFilePath) {
        this.destFilePath = destFilePath;
    }

    public void destFilePath(String multirequestToken) {
        this.setToken("destFilePath", multirequestToken);
    }

    public String getFlavorAssetId() {
        return this.flavorAssetId;
    }

    public void setFlavorAssetId(String flavorAssetId) {
        this.flavorAssetId = flavorAssetId;
    }

    public void flavorAssetId(String multirequestToken) {
        this.setToken("flavorAssetId", multirequestToken);
    }

    public Double getOffset() {
        return this.offset;
    }

    public void setOffset(Double offset) {
        this.offset = offset;
    }

    public void offset(String multirequestToken) {
        this.setToken("offset", multirequestToken);
    }

    public Double getDuration() {
        return this.duration;
    }

    public void setDuration(Double duration) {
        this.duration = duration;
    }

    public void duration(String multirequestToken) {
        this.setToken("duration", multirequestToken);
    }

    public Double getConcatenatedDuration() {
        return this.concatenatedDuration;
    }

    public void setConcatenatedDuration(Double concatenatedDuration) {
        this.concatenatedDuration = concatenatedDuration;
    }

    public void concatenatedDuration(String multirequestToken) {
        this.setToken("concatenatedDuration", multirequestToken);
    }

    public Boolean getShouldSort() {
        return this.shouldSort;
    }

    public void setShouldSort(Boolean shouldSort) {
        this.shouldSort = shouldSort;
    }

    public void shouldSort(String multirequestToken) {
        this.setToken("shouldSort", multirequestToken);
    }

    public ConcatJobData() {
    }

    public ConcatJobData(JsonObject jsonObject) throws APIException {
        super(jsonObject);
        if (jsonObject == null) {
            return;
        }
        this.srcFiles = GsonParser.parseArray(jsonObject.getAsJsonArray("srcFiles"), StringHolder.class);
        this.destFilePath = GsonParser.parseString(jsonObject.get("destFilePath"));
        this.flavorAssetId = GsonParser.parseString(jsonObject.get("flavorAssetId"));
        this.offset = GsonParser.parseDouble(jsonObject.get("offset"));
        this.duration = GsonParser.parseDouble(jsonObject.get("duration"));
        this.concatenatedDuration = GsonParser.parseDouble(jsonObject.get("concatenatedDuration"));
        this.shouldSort = GsonParser.parseBoolean(jsonObject.get("shouldSort"));
    }

    @Override
    public Params toParams() {
        Params kparams = super.toParams();
        kparams.add("objectType", "KalturaConcatJobData");
        kparams.add("srcFiles", this.srcFiles);
        kparams.add("destFilePath", this.destFilePath);
        kparams.add("flavorAssetId", this.flavorAssetId);
        kparams.add("offset", this.offset);
        kparams.add("duration", this.duration);
        kparams.add("concatenatedDuration", this.concatenatedDuration);
        kparams.add("shouldSort", this.shouldSort);
        return kparams;
    }

    public static interface Tokenizer
    extends JobData.Tokenizer {
        public RequestBuilder.ListTokenizer<StringHolder.Tokenizer> srcFiles();

        public String destFilePath();

        public String flavorAssetId();

        public String offset();

        public String duration();

        public String concatenatedDuration();

        public String shouldSort();
    }
}

